/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.springmerge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.Mergeable;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.util.Assert;

public class BeanDefinitionProxy
extends GenericBeanDefinition
implements BeanDefinition {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(BeanDefinitionProxy.class);
    private final BeanDefinition mergedBeanDefinition;
    private final BeanDefinition currentBeanDefinition;
    private boolean isMergedPropertyValues = false;
    private boolean isBeanClassNameUpdated = false;

    public BeanDefinitionProxy(BeanDefinition mergedBeanDefinition, BeanDefinition currentBeanDefinition) {
        super(currentBeanDefinition);
        String currentBeanClassName = currentBeanDefinition.getBeanClassName();
        String mergeBeanClassName = mergedBeanDefinition.getBeanClassName();
        if (!StringUtils.equals((String)currentBeanClassName, (String)mergeBeanClassName)) {
            if (mergedBeanDefinition instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)mergedBeanDefinition).hasBeanClass()) {
                this.setBeanClass(((AbstractBeanDefinition)mergedBeanDefinition).getBeanClass());
            } else {
                this.setBeanClass(null);
            }
        }
        Assert.notNull((Object)mergedBeanDefinition);
        Assert.notNull((Object)currentBeanDefinition);
        this.mergedBeanDefinition = mergedBeanDefinition;
        this.currentBeanDefinition = currentBeanDefinition;
    }

    public Class<?> getBeanClass() throws IllegalStateException {
        Class beanClassObject = super.getBeanClass();
        if (beanClassObject == null && this.mergedBeanDefinition instanceof AbstractBeanDefinition) {
            return ((AbstractBeanDefinition)this.mergedBeanDefinition).getBeanClass();
        }
        if (beanClassObject == null) {
            throw new IllegalStateException("No bean class specified on bean definition");
        }
        if (!(beanClassObject instanceof Class)) {
            throw new IllegalStateException("Bean class name [" + beanClassObject + "] has not been resolved into an actual Class");
        }
        return beanClassObject;
    }

    public String getBeanClassName() {
        String currentBeanClassName = this.currentBeanDefinition.getBeanClassName();
        String mergeBeanClassName = this.mergedBeanDefinition.getBeanClassName();
        if (mergeBeanClassName == null || currentBeanClassName.equals(mergeBeanClassName)) {
            return currentBeanClassName;
        }
        this.currentBeanDefinition.setBeanClassName(mergeBeanClassName);
        this.isBeanClassNameUpdated = true;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06\u539fBeanClassName\u5c5e\u6027\u503c:" + currentBeanClassName + "\u66ff\u6362\u4e3a" + mergeBeanClassName));
        }
        return mergeBeanClassName;
    }

    public ConstructorArgumentValues getConstructorArgumentValues() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.getConstructorArgumentValues();
        }
        ConstructorArgumentValues mergedCAV = this.mergedBeanDefinition.getConstructorArgumentValues();
        ConstructorArgumentValues currentCAV = this.currentBeanDefinition.getConstructorArgumentValues();
        if (mergedCAV == null || mergedCAV.getArgumentCount() < 1 || mergedCAV.equals((Object)currentCAV)) {
            return currentCAV;
        }
        this.currentBeanDefinition.getConstructorArgumentValues().clear();
        this.currentBeanDefinition.getConstructorArgumentValues().addArgumentValues(mergedCAV);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06\u539fConstructorArgumentValues\u5c5e\u6027\u503c:" + currentCAV + "\u66ff\u6362\u4e3a" + mergedCAV));
        }
        return mergedCAV;
    }

    public String getFactoryBeanName() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.getFactoryBeanName();
        }
        String mergedFactoryBeanName = this.mergedBeanDefinition.getFactoryBeanName();
        String currentFactoryBeanName = this.currentBeanDefinition.getFactoryBeanName();
        if (mergedFactoryBeanName == null || mergedFactoryBeanName.equals(currentFactoryBeanName)) {
            return currentFactoryBeanName;
        }
        this.currentBeanDefinition.setFactoryMethodName(mergedFactoryBeanName);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06\u539fFactoryBeanName\u5c5e\u6027\u503c:" + currentFactoryBeanName + "\u66ff\u6362\u4e3a" + mergedFactoryBeanName));
        }
        return mergedFactoryBeanName;
    }

    public String getFactoryMethodName() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.getFactoryMethodName();
        }
        String mergedFactoryMethodName = this.mergedBeanDefinition.getFactoryMethodName();
        String currentFactoryMethodName = this.currentBeanDefinition.getFactoryMethodName();
        if (mergedFactoryMethodName == null || mergedFactoryMethodName.equals(currentFactoryMethodName)) {
            return currentFactoryMethodName;
        }
        this.currentBeanDefinition.setFactoryBeanName(mergedFactoryMethodName);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06\u539ffactoryMethodName\u5c5e\u6027\u503c:" + currentFactoryMethodName + "\u66ff\u6362\u4e3a" + mergedFactoryMethodName));
        }
        return mergedFactoryMethodName;
    }

    public BeanDefinition getOriginatingBeanDefinition() {
        return this.currentBeanDefinition.getOriginatingBeanDefinition();
    }

    public String getParentName() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.getParentName();
        }
        String mergedParentName = this.mergedBeanDefinition.getParentName();
        String currentParentName = this.currentBeanDefinition.getParentName();
        if (mergedParentName == null || mergedParentName.equals(currentParentName)) {
            return currentParentName;
        }
        this.currentBeanDefinition.setParentName(currentParentName);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06\u539fparentName\u5c5e\u6027\u503c:" + currentParentName + "\u66ff\u6362\u4e3a" + mergedParentName));
        }
        return mergedParentName;
    }

    public MutablePropertyValues getPropertyValues() {
        PropertyValue[] mergedPvArray;
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.getPropertyValues();
        }
        MutablePropertyValues currentMpv = this.currentBeanDefinition.getPropertyValues();
        if (this.isMergedPropertyValues) {
            return currentMpv;
        }
        MutablePropertyValues mergedMpv = this.mergedBeanDefinition.getPropertyValues();
        if (currentMpv.equals((Object)mergedMpv)) {
            return currentMpv;
        }
        for (PropertyValue pv : mergedPvArray = mergedMpv.getPropertyValues()) {
            String mergedName = pv.getName();
            Object mergedValue = pv.getValue();
            PropertyValue currentPV = currentMpv.getPropertyValue(mergedName);
            if (currentPV == null) {
                PropertyValue hintpv;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("\u5c06\u9700\u8981merged(PropertyValues)(" + mergedName + ")value:" + mergedValue + "\u76f4\u63a5\u65b0\u589e\u5230spring'" + this.getBeanClassName() + "'\u4e2d"));
                }
                if (mergedValue instanceof Mergeable && ((Mergeable)mergedValue).isMergeEnabled() && (hintpv = currentMpv.getPropertyValue("merge")) != null) {
                    hintpv.setConvertedValue((Object)Boolean.TRUE);
                }
                currentMpv.addPropertyValue(pv);
                continue;
            }
            Object currentValue = currentPV.getValue();
            if (mergedValue.equals(currentValue)) continue;
            currentPV.removeAttribute(mergedName);
            currentMpv.removePropertyValue(mergedName);
            if (mergedValue instanceof RuntimeBeanReference || mergedValue instanceof BeanDefinitionHolder) {
                currentMpv.addPropertyValue(mergedName, mergedValue);
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("\u5c06\u539f\u5c5e\u6027\u503c(PropertyValues)(" + mergedName + ")value:" + currentValue + "\u66ff\u6362\u4e3a" + mergedValue));
                continue;
            }
            if (mergedValue instanceof ManagedSet) {
                ManagedSet currentManagedSet = (ManagedSet)currentValue;
                ManagedSet mergedManagedSet = (ManagedSet)mergedValue;
                ManagedSet tempManagedSet = (ManagedSet)currentManagedSet.clone();
                if (mergedManagedSet.isMergeEnabled()) {
                    currentManagedSet.addAll((Collection)mergedManagedSet);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("\u5c06\u9700\u8981merged\u5c5e\u6027\u503c(PropertyValues)(" + mergedName + ")value:" + mergedValue + "\u548c\u73b0\u5c5e\u6027value" + tempManagedSet + "\u5408\u5e76\u4e3a" + currentManagedSet));
                    }
                } else {
                    currentManagedSet = mergedManagedSet;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("\u5c5e\u6027\u503c(PropertyValues)(" + mergedName + ")\u7531\u73b0\u5c5e\u6027value" + tempManagedSet + "\u76f4\u63a5\u66ff\u6362\u4e3a" + mergedValue));
                    }
                }
                currentMpv.addPropertyValue(mergedName, (Object)currentManagedSet);
                continue;
            }
            if (mergedValue instanceof ManagedList) {
                ManagedList currentManagedList = (ManagedList)currentValue;
                ManagedList managedListed = (ManagedList)currentManagedList.clone();
                ManagedList mergeManagedList = (ManagedList)mergedValue;
                if (mergeManagedList.isMergeEnabled()) {
                    currentManagedList.addAll((Collection)mergeManagedList);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("\u5c06\u9700\u8981merged\u5c5e\u6027\u503c(PropertyValues)(" + mergedName + ")value:" + mergedValue + "\u548c\u73b0\u5c5e\u6027value" + managedListed + "\u5408\u5e76\u4e3a" + currentManagedList));
                    }
                } else {
                    currentManagedList = mergeManagedList;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("\u5c5e\u6027\u503c(PropertyValues)(" + mergedName + ")\u7531\u73b0\u5c5e\u6027value" + managedListed + "\u76f4\u63a5\u66ff\u6362\u4e3a" + mergedValue));
                    }
                }
                currentMpv.addPropertyValue(mergedName, (Object)currentManagedList);
                continue;
            }
            if (mergedValue instanceof ManagedMap) {
                ManagedMap currentManagedMap = (ManagedMap)currentValue;
                ManagedMap managedMap = (ManagedMap)currentManagedMap.clone();
                ManagedMap mergeManagedMap = (ManagedMap)mergedValue;
                if (mergeManagedMap.isMergeEnabled()) {
                    currentManagedMap.putAll((Map)mergeManagedMap);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("\u5c06\u9700\u8981merged\u5c5e\u6027\u503c(PropertyValues)(" + mergedName + ")value:" + mergedValue + "\u548c\u73b0\u5c5e\u6027value" + managedMap + "\u5408\u5e76\u4e3a" + currentManagedMap));
                    }
                } else {
                    currentManagedMap = mergeManagedMap;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("\u5c5e\u6027\u503c(PropertyValues)(" + mergedName + ")\u7531\u73b0\u5c5e\u6027value" + managedMap + "\u76f4\u63a5\u66ff\u6362\u4e3a" + mergedValue));
                    }
                }
                currentMpv.addPropertyValue(mergedName, (Object)currentManagedMap);
                continue;
            }
            if (mergedValue instanceof ManagedProperties) {
                ManagedProperties currentManageProperties = (ManagedProperties)currentValue;
                ManagedProperties manageProperties = (ManagedProperties)currentManageProperties.clone();
                ManagedProperties mergedManageProperties = (ManagedProperties)mergedValue;
                if (mergedManageProperties.isMergeEnabled()) {
                    currentManageProperties.putAll((Map)mergedManageProperties);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("\u5c06\u9700\u8981merged\u5c5e\u6027\u503c(PropertyValues)(" + mergedName + ")value:" + mergedValue + "\u548c\u73b0\u5c5e\u6027value" + manageProperties + "\u5408\u5e76\u4e3a" + currentManageProperties));
                    }
                } else {
                    currentManageProperties = mergedManageProperties;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("\u5c5e\u6027\u503c(PropertyValues)(" + mergedName + ")\u7531\u73b0\u5c5e\u6027value" + manageProperties + "\u76f4\u63a5\u66ff\u6362\u4e3a" + mergedValue));
                    }
                }
                currentMpv.addPropertyValue(mergedName, (Object)currentManageProperties);
                continue;
            }
            currentMpv.removePropertyValue(mergedName);
            currentMpv.addPropertyValue(new PropertyValue(mergedName, mergedValue));
        }
        this.isMergedPropertyValues = true;
        return currentMpv;
    }

    public String getResourceDescription() {
        String currentRdes = this.currentBeanDefinition.getResourceDescription();
        String mergedRdes = this.mergedBeanDefinition.getResourceDescription();
        return mergedRdes + "(\u9700\u8981\u5408\u5e76)," + currentRdes + "(\u5f53\u524d)";
    }

    public int getRole() {
        int mergeRole = this.mergedBeanDefinition.getRole();
        int currentRole = this.currentBeanDefinition.getRole();
        if (mergeRole == 0 || mergeRole == currentRole) {
            return currentRole;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06\u539f\u6765role\u5c5e\u6027\u503c:" + currentRole + "\u89c4\u6362\u4e3a" + currentRole));
        }
        return mergeRole;
    }

    public String getScope() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.getScope();
        }
        String mergedScope = this.mergedBeanDefinition.getScope();
        String currentScope = this.currentBeanDefinition.getScope();
        if (currentScope == null) {
            currentScope = "singleton";
        }
        if (mergedScope == null || mergedScope.equals("singleton") || mergedScope.equals(currentScope)) {
            return currentScope;
        }
        this.currentBeanDefinition.setScope(mergedScope);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06\u539fscope\u5c5e\u6027\u503c" + currentScope + "\u66ff\u6362\u4e3a" + mergedScope));
        }
        return mergedScope;
    }

    public boolean isAbstract() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.isAbstract();
        }
        boolean mergedIsAbstract = this.mergedBeanDefinition.isAbstract();
        boolean currentIsAbstract = this.currentBeanDefinition.isAbstract();
        if (!mergedIsAbstract || mergedIsAbstract == currentIsAbstract) {
            return currentIsAbstract;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06\u539fisAbstract\u5c5e\u6027\u503c" + currentIsAbstract + "\u66ff\u6362\u4e3a" + mergedIsAbstract));
        }
        return mergedIsAbstract;
    }

    public boolean isAutowireCandidate() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.isAutowireCandidate();
        }
        boolean mergedIsAutowireCandidate = this.mergedBeanDefinition.isAutowireCandidate();
        boolean currentIsAutowireCandidate = this.currentBeanDefinition.isAutowireCandidate();
        if (mergedIsAutowireCandidate || mergedIsAutowireCandidate == currentIsAutowireCandidate) {
            return currentIsAutowireCandidate;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06\u539fisAbstract\u5c5e\u6027\u503c" + currentIsAutowireCandidate + "\u66ff\u6362\u4e3a" + mergedIsAutowireCandidate));
        }
        return mergedIsAutowireCandidate;
    }

    public boolean isLazyInit() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.isLazyInit();
        }
        boolean mergedIsLazyInit = this.mergedBeanDefinition.isLazyInit();
        boolean currentIsLazyInit = this.currentBeanDefinition.isLazyInit();
        if (!mergedIsLazyInit || mergedIsLazyInit == currentIsLazyInit) {
            return currentIsLazyInit;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06\u539fisLazyInit\u5c5e\u6027\u503c" + currentIsLazyInit + "\u66ff\u6362\u4e3a" + mergedIsLazyInit));
        }
        return mergedIsLazyInit;
    }

    public boolean isSingleton() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.isSingleton();
        }
        boolean mergedIsSingleton = this.mergedBeanDefinition.isSingleton();
        boolean currentIsSingleton = this.currentBeanDefinition.isSingleton();
        if (!mergedIsSingleton && mergedIsSingleton != currentIsSingleton) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("\u5c06\u539fisSingleton\u5c5e\u6027\u503c" + currentIsSingleton + "\u66ff\u6362\u4e3a" + mergedIsSingleton));
            }
            return mergedIsSingleton;
        }
        return currentIsSingleton;
    }

    public String[] attributeNames() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.attributeNames();
        }
        Object[] mergedAttributesNames = this.mergedBeanDefinition.attributeNames();
        Object[] currentAttributesNames = this.currentBeanDefinition.attributeNames();
        ArrayList<String> list = new ArrayList<String>();
        String[] newArray = (String[])ArrayUtils.addAll((Object[])currentAttributesNames, (Object[])currentAttributesNames);
        if (newArray.length < 1) {
            return new String[0];
        }
        for (String str : newArray) {
            if (!list.contains(str)) continue;
            list.add(str);
        }
        Object[] mergedArray = null;
        mergedArray = list.size() > 0 ? list.toArray(new String[list.size()]) : ArrayUtils.EMPTY_STRING_ARRAY;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u5c06attributeNames\u6570\u7ec4\u5c5e\u6027\u503c" + StringUtils.join((Object[])mergedAttributesNames) + "\u548c" + StringUtils.join((Object[])currentAttributesNames) + "copy\u5e76\u53bb\u91cd\u4e3a" + StringUtils.join((Object[])mergedArray)));
        }
        return mergedArray;
    }

    public Object getAttribute(String name) {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.getAttribute(name);
        }
        Object mergedAttribute = this.mergedBeanDefinition.getAttribute(name);
        Object currentAttribute = this.currentBeanDefinition.getAttribute(name);
        if (mergedAttribute == null || mergedAttribute.equals(currentAttribute)) {
            return currentAttribute;
        }
        this.currentBeanDefinition.setAttribute(name, mergedAttribute);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u539fattribute(" + name + ")\u5c5e\u6027\u503c:" + mergedAttribute + "\u66ff\u6362\u4e3a" + currentAttribute));
        }
        return mergedAttribute;
    }

    public boolean hasAttribute(String name) {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.hasAttribute(name);
        }
        boolean mergedhasAttribute = this.mergedBeanDefinition.hasAttribute(name);
        boolean currenthasAttribute = this.currentBeanDefinition.hasAttribute(name);
        if (currenthasAttribute || mergedhasAttribute) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("\u5c06\u539fhasAttribute\u5c5e\u6027\u503c" + currenthasAttribute + "\u66ff\u6362\u4e3a" + mergedhasAttribute));
            }
            return true;
        }
        return false;
    }

    public Object removeAttribute(String name) {
        return this.currentBeanDefinition.removeAttribute(name);
    }

    public Object getSource() {
        if (this.isBeanClassNameUpdated) {
            return this.mergedBeanDefinition.getSource();
        }
        Object mergedSource = this.mergedBeanDefinition.getSource();
        Object currentSource = this.currentBeanDefinition.getSource();
        if (mergedSource == null || mergedSource.equals(currentSource)) {
            return currentSource;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u539fsource\u5c5e\u6027\u503c" + currentSource + "\u66ff\u6362\u4e3a" + mergedSource));
        }
        return mergedSource;
    }

    public MethodOverrides getMethodOverrides() {
        MethodOverrides currentMethodOverrides = ((AbstractBeanDefinition)this.currentBeanDefinition).getMethodOverrides();
        MethodOverrides mergedMethodOverrides = ((AbstractBeanDefinition)this.mergedBeanDefinition).getMethodOverrides();
        currentMethodOverrides.addOverrides(mergedMethodOverrides);
        return currentMethodOverrides;
    }
}

