/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.springmerge.beanfactory;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.tinygroup.springmerge.BeanDefinitionProxy;

public class SpringMergeApplicationContext
extends XmlWebApplicationContext {
    private BeanDefinitionRegistry mergedBeanDefinitionRegistry;

    public SpringMergeApplicationContext(BeanDefinitionRegistry mergedBeanDefinitionRegistry) {
        this.mergedBeanDefinitionRegistry = mergedBeanDefinitionRegistry;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws BeansException, IOException {
        super.loadBeanDefinitions(beanFactory);
        String[] beanDefinitionNames = this.mergedBeanDefinitionRegistry.getBeanDefinitionNames();
        if (beanDefinitionNames != null && beanDefinitionNames.length > 0) {
            this.logger.info((Object)"========================\u5f00\u59cb\u5408\u5e76spring\u914d\u7f6e ========================");
            for (String beanName : beanDefinitionNames) {
                BeanDefinition mergedBd = this.mergedBeanDefinitionRegistry.getBeanDefinition(beanName);
                BeanDefinition currentBd = this.getCurrentBdIfExisted(beanFactory, beanName);
                if (currentBd != null) {
                    this.logger.info((Object)(beanName + "\u5728\u5f53\u524dspring\u4e2d\u5b58\u5728,\u9700\u8981\u66ff\u6362"));
                    currentBd = new BeanDefinitionProxy(mergedBd, currentBd);
                } else {
                    this.logger.info((Object)(beanName + "\u5728\u5f53\u524dspring\u4e2d\u4e0d\u5b58\u5728\uff0c\u76f4\u63a5\u6ce8\u518c\u5230\u5f53\u524d\u4e0a\u4e0b\u6587"));
                    currentBd = mergedBd;
                }
                beanFactory.registerBeanDefinition(beanName, currentBd);
            }
            this.logger.info((Object)"========================\u5408\u5e76spring\u914d\u7f6e\u7ed3\u675f ========================");
        }
    }

    private BeanDefinition getCurrentBdIfExisted(DefaultListableBeanFactory currentBeanFactory, String beanName) {
        if (currentBeanFactory != null) {
            if (!currentBeanFactory.containsBeanDefinition(beanName)) {
                BeanFactory beanFactory = currentBeanFactory.getParentBeanFactory();
                if (beanFactory instanceof DefaultListableBeanFactory) {
                    return this.getCurrentBdIfExisted((DefaultListableBeanFactory)beanFactory, beanName);
                }
                return null;
            }
            return currentBeanFactory.getMergedBeanDefinition(beanName);
        }
        return null;
    }
}

