/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evidently.EvidentlyClient;
import software.amazon.awssdk.services.evidently.internal.UserAgentUtils;
import software.amazon.awssdk.services.evidently.model.ListSegmentsRequest;
import software.amazon.awssdk.services.evidently.model.ListSegmentsResponse;
import software.amazon.awssdk.services.evidently.model.Segment;

public class ListSegmentsIterable
implements SdkIterable<ListSegmentsResponse> {
    private final EvidentlyClient client;
    private final ListSegmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSegmentsIterable(EvidentlyClient client, ListSegmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSegmentsResponseFetcher();
    }

    public Iterator<ListSegmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Segment> segments() {
        Function<ListSegmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.segments() != null) {
                return response.segments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSegmentsResponseFetcher
    implements SyncPageFetcher<ListSegmentsResponse> {
        private ListSegmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListSegmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSegmentsResponse nextPage(ListSegmentsResponse previousPage) {
            if (previousPage == null) {
                return ListSegmentsIterable.this.client.listSegments(ListSegmentsIterable.this.firstRequest);
            }
            return ListSegmentsIterable.this.client.listSegments((ListSegmentsRequest)((Object)ListSegmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

