/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse;
import software.amazon.awssdk.services.route53resolver.model.ResolverRule;

public class ListResolverRulesIterable
implements SdkIterable<ListResolverRulesResponse> {
    private final Route53ResolverClient client;
    private final ListResolverRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResolverRulesIterable(Route53ResolverClient client, ListResolverRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResolverRulesResponseFetcher();
    }

    public Iterator<ListResolverRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResolverRule> resolverRules() {
        Function<ListResolverRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolverRules() != null) {
                return response.resolverRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResolverRulesResponseFetcher
    implements SyncPageFetcher<ListResolverRulesResponse> {
        private ListResolverRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResolverRulesResponse nextPage(ListResolverRulesResponse previousPage) {
            if (previousPage == null) {
                return ListResolverRulesIterable.this.client.listResolverRules(ListResolverRulesIterable.this.firstRequest);
            }
            return ListResolverRulesIterable.this.client.listResolverRules((ListResolverRulesRequest)((Object)ListResolverRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

