/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ses.DefaultSesAsyncClient;
import software.amazon.awssdk.services.ses.DefaultSesBaseClientBuilder;
import software.amazon.awssdk.services.ses.SesAsyncClient;
import software.amazon.awssdk.services.ses.SesAsyncClientBuilder;
import software.amazon.awssdk.services.ses.SesServiceClientConfiguration;
import software.amazon.awssdk.services.ses.endpoints.SesEndpointProvider;

@SdkInternalApi
final class DefaultSesAsyncClientBuilder
extends DefaultSesBaseClientBuilder<SesAsyncClientBuilder, SesAsyncClient>
implements SesAsyncClientBuilder {
    DefaultSesAsyncClientBuilder() {
    }

    @Override
    public DefaultSesAsyncClientBuilder endpointProvider(SesEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SesAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSesAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SesServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSesAsyncClient client = new DefaultSesAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SesServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SesServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

