/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class ReusableGzipOutputStream
extends DeflaterOutputStream {
    private final CRC32 crc = new CRC32();
    private static final int GZIP_MAGIC = 35615;
    private static final int TRAILER_SIZE = 8;

    public ReusableGzipOutputStream(OutputStream out) throws IOException {
        super(out, new Deflater(-1, true));
        this.crc.reset();
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
    }

    @Override
    public void finish() throws IOException {
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                int len = this.def.deflate(this.buf, 0, this.buf.length);
                if (this.def.finished() && len <= this.buf.length - 8) {
                    this.writeTrailer(this.buf, len);
                    this.out.write(this.buf, 0, len += 8);
                    return;
                }
                if (len <= 0) continue;
                this.out.write(this.buf, 0, len);
            }
            byte[] trailer = new byte[8];
            this.writeTrailer(trailer, 0);
            this.out.write(trailer);
        }
    }

    public void writeHeader() throws IOException {
        this.out.write(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0});
    }

    private void writeTrailer(byte[] buf, int offset) throws IOException {
        this.writeInt((int)this.crc.getValue(), buf, offset);
        this.writeInt(this.def.getTotalIn(), buf, offset + 4);
    }

    private void writeInt(int i, byte[] buf, int offset) throws IOException {
        this.writeShort(i & 0xFFFF, buf, offset);
        this.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
    }

    private void writeShort(int s, byte[] buf, int offset) throws IOException {
        buf[offset] = (byte)(s & 0xFF);
        buf[offset + 1] = (byte)(s >> 8 & 0xFF);
    }

    public void reset() {
        this.crc.reset();
        this.def.reset();
    }
}

