/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.BCD;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.BaseAsymmetric;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class AbstractAsymmetricCrypto<T extends AbstractAsymmetricCrypto<T>>
extends BaseAsymmetric<T> {
    public AbstractAsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public abstract byte[] encrypt(byte[] var1, KeyType var2);

    public String encryptHex(byte[] data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (String)charset), keyType);
    }

    public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)charset), keyType);
    }

    public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)CharsetUtil.CHARSET_UTF_8), keyType);
    }

    public String encryptHex(String data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    public String encryptHex(String data, Charset charset, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, charset, keyType));
    }

    public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    public String encryptBase64(String data, Charset charset, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, charset, keyType));
    }

    public byte[] encrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes((InputStream)data), keyType);
    }

    public String encryptHex(InputStream data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    public String encryptBcd(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    public String encryptBcd(String data, KeyType keyType, Charset charset) {
        return BCD.bcdToStr((byte[])this.encrypt(data, charset, keyType));
    }

    public abstract byte[] decrypt(byte[] var1, KeyType var2);

    public byte[] decrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes((InputStream)data), keyType);
    }

    public byte[] decryptFromHex(String hexStr, KeyType keyType) {
        return this.decrypt(HexUtil.decodeHex((String)hexStr), keyType);
    }

    public byte[] decryptFromBase64(String base64Str, KeyType keyType) {
        return this.decrypt(Base64.decode((String)base64Str, (Charset)CharsetUtil.CHARSET_UTF_8), keyType);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType) {
        return this.decryptFromBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType, Charset charset) {
        byte[] dataBytes = BCD.ascToBcd((byte[])StrUtil.bytes((CharSequence)data, (Charset)charset));
        return this.decrypt(dataBytes, keyType);
    }
}

