/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.BouncyCastleSupport;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.digest.DigestAlgorithm;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Digester
extends BouncyCastleSupport {
    private MessageDigest digest;
    protected byte[] salt;
    protected int digestCount;

    public Digester(DigestAlgorithm algorithm) {
        this(algorithm.getValue());
    }

    public Digester(String algorithm) {
        this.init(algorithm);
    }

    public Digester init(String algorithm) {
        try {
            this.digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public Digester setSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public Digester setDigestCount(int digestCount) {
        this.digestCount = digestCount;
        return this;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StrUtil.bytes((CharSequence)data, (String)charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexUtil.encodeHexStr((byte[])this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CryptoException {
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream((File)file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IoUtil.close((Closeable)in);
        }
    }

    public String digestHex(File file) {
        return HexUtil.encodeHexStr((byte[])this.digest(file));
    }

    public byte[] digest(byte[] data) {
        if (null != this.salt) {
            this.digest.update(this.salt);
        }
        int digestCount = Math.max(1, this.digestCount);
        byte[] result = data;
        for (int i = 0; i < digestCount; ++i) {
            result = this.doDigest(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doDigest(byte[] data) {
        byte[] result;
        try {
            result = this.digest.digest(data);
        }
        finally {
            this.digest.reset();
        }
        return result;
    }

    public String digestHex(byte[] data) {
        return HexUtil.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 2048);
    }

    public String digestHex(InputStream data) {
        return HexUtil.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) throws CryptoException {
        if (bufferLength < 1) {
            bufferLength = 2048;
        }
        byte[] buffer = new byte[bufferLength];
        byte[] result = null;
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.digest.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = this.digest.digest();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            this.digest.reset();
        }
        return result;
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtil.encodeHexStr((byte[])this.digest(data, bufferLength));
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    public int getDigestLength() {
        return this.digest.getDigestLength();
    }
}

