/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.velocity;

import cn.hutool.core.exceptions.NotInitedException;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.IdUtil;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityUtil {
    private static boolean isInited;
    private static Map<String, Object> globalContext;

    public void putGlobalContext(String name, Object value) {
        globalContext.put(name, value);
    }

    public static synchronized void init(String templateDir, String charset) {
        Velocity.init((Properties)VelocityUtil._newInitedProp(templateDir, charset));
        Velocity.setProperty((String)"file.resource.loader.cache", (Object)true);
        isInited = true;
    }

    public static void init(String templateDir, String charset, Map<String, Object> initedGlobalContext) {
        globalContext.putAll(initedGlobalContext);
        VelocityUtil.init(templateDir, charset);
    }

    public static VelocityEngine newEngine(String templateDir, String charset) {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("file.resource.loader.cache", (Object)true);
        ve.init(VelocityUtil._newInitedProp(templateDir, charset));
        return ve;
    }

    public static String getContent(String templateDir, String templateFileName, VelocityContext context, String charset) {
        VelocityEngine ve = VelocityUtil.newEngine(templateDir, charset);
        return VelocityUtil.getContent(ve, templateFileName, context);
    }

    public static String getContent(VelocityEngine ve, String templateFileName, VelocityContext context) {
        StringWriter writer = new StringWriter();
        VelocityUtil.toWriter(ve, templateFileName, context, writer);
        return writer.toString();
    }

    public static String getContent(String templateFileName, VelocityContext context) {
        StringWriter writer = new StringWriter();
        VelocityUtil.toWriter(templateFileName, context, writer);
        return writer.toString();
    }

    public static void toFile(VelocityEngine ve, String templateFileName, VelocityContext context, String destPath) {
        VelocityUtil.toFile(ve.getTemplate(templateFileName), context, destPath);
    }

    public static void toFile(String templateFileName, VelocityContext context, String destPath) {
        VelocityUtil.assertInit();
        VelocityUtil.toFile(Velocity.getTemplate((String)templateFileName), context, destPath);
    }

    public static void toFile(Template template, VelocityContext context, String destPath) {
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter((String)destPath, (String)Velocity.getProperty((String)"input.encoding").toString(), (boolean)false);
            VelocityUtil.merge(template, context, writer);
        }
        catch (IORuntimeException e) {
            try {
                throw new UtilException((Throwable)e, "Write Velocity content to [{}] error!", new Object[]{destPath});
            }
            catch (Throwable throwable) {
                IoUtil.close(writer);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)writer);
    }

    public static void toWriter(VelocityEngine ve, String templateFileName, VelocityContext context, Writer writer) {
        Template template = ve.getTemplate(templateFileName);
        VelocityUtil.merge(template, context, writer);
    }

    public static void toWriter(String templateFileName, VelocityContext context, Writer writer) {
        VelocityUtil.assertInit();
        Template template = Velocity.getTemplate((String)templateFileName);
        VelocityUtil.merge(template, context, writer);
    }

    public static void toWriter(String templateFileName, HttpServletRequest request, HttpServletResponse response) {
        VelocityContext context = new VelocityContext();
        VelocityUtil.parseRequest(context, request);
        VelocityUtil.parseSession(context, request.getSession(false));
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            VelocityUtil.toWriter(templateFileName, context, writer);
        }
        catch (Exception e) {
            throw new UtilException((Throwable)e, "Write Velocity content template by [{}] to response error!", new Object[]{templateFileName});
        }
        finally {
            IoUtil.close((Closeable)writer);
        }
    }

    public static String merge(String templateContent, VelocityContext context) {
        StringWriter writer = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)writer, (String)IdUtil.randomUUID(), (String)templateContent);
        }
        catch (Exception e) {
            throw new UtilException((Throwable)e);
        }
        return writer.toString();
    }

    public static void merge(Template template, VelocityContext context, Writer writer) {
        if (template == null) {
            throw new UtilException("Template is null");
        }
        if (context == null) {
            context = new VelocityContext(globalContext);
        } else {
            for (Map.Entry<String, Object> entry : globalContext.entrySet()) {
                context.put(entry.getKey(), entry.getValue());
            }
        }
        template.merge((Context)context, writer);
    }

    public static VelocityContext parseRequest(VelocityContext context, HttpServletRequest request) {
        Enumeration attrs = request.getAttributeNames();
        if (attrs != null) {
            String attrName = null;
            while (attrs.hasMoreElements()) {
                attrName = (String)attrs.nextElement();
                context.put(attrName, request.getAttribute(attrName));
            }
        }
        return context;
    }

    public static VelocityContext parseSession(VelocityContext context, HttpSession session) {
        Enumeration sessionAttrs;
        if (null != session && (sessionAttrs = session.getAttributeNames()) != null) {
            String attrName = null;
            while (sessionAttrs.hasMoreElements()) {
                attrName = (String)sessionAttrs.nextElement();
                context.put(attrName, session.getAttribute(attrName));
            }
        }
        return context;
    }

    private static Properties _newInitedProp(String templateDir, String charset) {
        Properties properties = new Properties();
        properties.setProperty("file.resource.loader.path", templateDir);
        properties.setProperty("UTF-8", charset);
        properties.setProperty("input.encoding", charset);
        return properties;
    }

    private static void assertInit() {
        if (!isInited) {
            throw new NotInitedException("Please use VelocityUtil.init() method to init Velocity default engine!");
        }
    }

    static {
        globalContext = new HashMap<String, Object>();
    }
}

