/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.AnnotationVisitor;
import co.paralleluniverse.asm.Label;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.asm.Type;
import co.paralleluniverse.asm.tree.AbstractInsnNode;
import co.paralleluniverse.asm.tree.AnnotationNode;
import co.paralleluniverse.asm.tree.InsnList;
import co.paralleluniverse.asm.tree.InvokeDynamicInsnNode;
import co.paralleluniverse.asm.tree.JumpInsnNode;
import co.paralleluniverse.asm.tree.LabelNode;
import co.paralleluniverse.asm.tree.LineNumberNode;
import co.paralleluniverse.asm.tree.LocalVariableNode;
import co.paralleluniverse.asm.tree.MethodInsnNode;
import co.paralleluniverse.asm.tree.MethodNode;
import co.paralleluniverse.asm.tree.TryCatchBlockNode;
import co.paralleluniverse.asm.tree.analysis.AnalyzerException;
import co.paralleluniverse.asm.tree.analysis.BasicValue;
import co.paralleluniverse.asm.tree.analysis.Frame;
import co.paralleluniverse.asm.tree.analysis.Value;
import co.paralleluniverse.fibers.instrument.Classes;
import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.NewValue;
import co.paralleluniverse.fibers.instrument.TypeAnalyzer;
import co.paralleluniverse.fibers.instrument.UnableToInstrumentException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class InstrumentMethod {
    private static final boolean optimizationDisabled = false;
    private static final boolean HANDLE_PROXY_INVOCATIONS = true;
    private static final int PREEMPTION_BACKBRANCH = 0;
    private static final int PREEMPTION_CALL = 1;
    private final MethodDatabase db;
    private final String sourceName;
    private final String className;
    private final MethodNode mn;
    private final Frame[] frames;
    private static final int NUM_LOCALS = 3;
    private static final int ADD_OPERANDS = 6;
    private final int lvarStack;
    private final int lvarResumed;
    private final int lvarInvocationReturnValue;
    private final int firstLocal;
    private FrameInfo[] codeBlocks = new FrameInfo[32];
    private int numCodeBlocks;
    private int additionalLocals;
    private boolean warnedAboutMonitors;
    private int warnedAboutBlocking;
    private boolean callsSuspendableSupers;
    private int startSourceLine = -1;
    private int endSourceLine = -1;
    private int[] suspCallsSourceLines = new int[8];
    private int[] suspCallsBcis = null;

    public InstrumentMethod(MethodDatabase db, String sourceName, String className, MethodNode mn) throws AnalyzerException {
        this.db = db;
        this.sourceName = sourceName;
        this.className = className;
        this.mn = mn;
        try {
            TypeAnalyzer a = new TypeAnalyzer(db);
            this.frames = a.analyze(className, mn);
            this.lvarStack = mn.maxLocals;
            this.lvarResumed = mn.maxLocals + 1;
            this.lvarInvocationReturnValue = mn.maxLocals + 2;
            this.firstLocal = (mn.access & 8) == 8 ? 0 : 1;
        }
        catch (UnsupportedOperationException ex) {
            throw new AnalyzerException(null, ex.getMessage(), ex);
        }
    }

    public boolean callsSuspendables() {
        if (this.suspCallsBcis == null) {
            this.suspCallsBcis = new int[8];
            int numIns = this.mn.instructions.size();
            int currSourceLine = -1;
            int count = 0;
            for (int i = 0; i < numIns; ++i) {
                Frame f = this.frames[i];
                if (f == null) continue;
                AbstractInsnNode in = this.mn.instructions.get(i);
                if (in.getType() == 15) {
                    LineNumberNode lnn = (LineNumberNode)in;
                    currSourceLine = lnn.line;
                    if (this.startSourceLine == -1 || currSourceLine < this.startSourceLine) {
                        this.startSourceLine = currSourceLine;
                    }
                    if (this.endSourceLine != -1 && currSourceLine <= this.endSourceLine) continue;
                    this.endSourceLine = currSourceLine;
                    continue;
                }
                if (in.getType() != 5 && in.getType() != 6) continue;
                if (this.isSuspendableCall(in)) {
                    if (count >= this.suspCallsBcis.length) {
                        this.suspCallsBcis = Arrays.copyOf(this.suspCallsBcis, this.suspCallsBcis.length * 2);
                    }
                    if (count >= this.suspCallsSourceLines.length) {
                        this.suspCallsSourceLines = Arrays.copyOf(this.suspCallsSourceLines, this.suspCallsSourceLines.length * 2);
                    }
                    this.suspCallsBcis[count] = i;
                    this.suspCallsSourceLines[count] = currSourceLine;
                    ++count;
                    continue;
                }
                this.possiblyWarnAboutBlocking(in);
            }
            if (count < this.suspCallsSourceLines.length) {
                this.suspCallsSourceLines = Arrays.copyOf(this.suspCallsSourceLines, count);
            }
            if (count < this.suspCallsBcis.length) {
                this.suspCallsBcis = Arrays.copyOf(this.suspCallsBcis, count);
            }
        }
        return this.suspCallsBcis.length > 0;
    }

    private boolean isSuspendableCall(AbstractInsnNode in) {
        boolean susp = true;
        if (in.getType() == 5) {
            MethodDatabase.SuspendableType st;
            MethodInsnNode min = (MethodInsnNode)in;
            if (!(MethodDatabase.isSyntheticAccess(min.owner, min.name) || MethodDatabase.isReflectInvocation(min.owner, min.name) || MethodDatabase.isMethodHandleInvocation(min.owner, min.name) || MethodDatabase.isInvocationHandlerInvocation(min.owner, min.name) || (st = this.db.isMethodSuspendable(min.owner, min.name, min.desc, min.getOpcode())) != MethodDatabase.SuspendableType.NON_SUSPENDABLE)) {
                susp = false;
            }
        } else if (in.getType() == 6) {
            InvokeDynamicInsnNode idin = (InvokeDynamicInsnNode)in;
            if (idin.bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory")) {
                susp = false;
            }
        } else {
            susp = false;
        }
        return susp;
    }

    private void collectCodeBlocks() {
        int numIns = this.mn.instructions.size();
        this.codeBlocks[0] = FrameInfo.FIRST;
        for (int i = 0; i < numIns; ++i) {
            MethodInsnNode min;
            AbstractInsnNode in;
            Frame f = this.frames[i];
            if (f == null || (in = this.mn.instructions.get(i)).getType() != 5 && in.getType() != 6) continue;
            boolean susp = true;
            if (in.getType() == 5) {
                min = (MethodInsnNode)in;
                int opcode = min.getOpcode();
                if (MethodDatabase.isSyntheticAccess(min.owner, min.name)) {
                    this.db.log(LogLevel.DEBUG, "Synthetic accessor method call at instruction %d is assumed suspendable", i);
                } else if (MethodDatabase.isReflectInvocation(min.owner, min.name)) {
                    this.db.log(LogLevel.DEBUG, "Reflective method call at instruction %d is assumed suspendable", i);
                } else if (MethodDatabase.isMethodHandleInvocation(min.owner, min.name)) {
                    this.db.log(LogLevel.DEBUG, "MethodHandle invocation at instruction %d is assumed suspendable", i);
                } else if (MethodDatabase.isInvocationHandlerInvocation(min.owner, min.name)) {
                    this.db.log(LogLevel.DEBUG, "InvocationHandler invocation at instruction %d is assumed suspendable", i);
                } else {
                    MethodDatabase.SuspendableType st = this.db.isMethodSuspendable(min.owner, min.name, min.desc, opcode);
                    if (st == MethodDatabase.SuspendableType.NON_SUSPENDABLE) {
                        susp = false;
                    } else if (st == null) {
                        this.db.log(LogLevel.WARNING, "Method not found in class - assuming suspendable: %s#%s%s (at %s#%s)", min.owner, min.name, min.desc, this.className, this.mn.name);
                        susp = true;
                    } else if (susp && st != MethodDatabase.SuspendableType.SUSPENDABLE_SUPER) {
                        this.db.log(LogLevel.DEBUG, "Method call at instruction %d to %s#%s%s is suspendable", i, min.owner, min.name, min.desc);
                    }
                    if (st == MethodDatabase.SuspendableType.SUSPENDABLE_SUPER) {
                        this.db.log(LogLevel.DEBUG, "Method call at instruction %d to %s#%s%s to suspendable-super (instrumentation for proxy support will be enabled)", i, min.owner, min.name, min.desc);
                        this.callsSuspendableSupers = true;
                    }
                }
            } else if (in.getType() == 6) {
                InvokeDynamicInsnNode idin = (InvokeDynamicInsnNode)in;
                if (idin.bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory")) {
                    this.db.log(LogLevel.DEBUG, "Lambda at instruction %d", i);
                    susp = false;
                } else {
                    this.db.log(LogLevel.DEBUG, "InvokeDynamic Method call at instruction %d to is assumed suspendable", i);
                }
            }
            if (susp) {
                FrameInfo fi = this.addCodeBlock(f, i);
                this.splitTryCatch(fi);
                continue;
            }
            if (in.getType() != 5) continue;
            min = (MethodInsnNode)in;
            this.db.log(LogLevel.DEBUG, "Method call at instruction %d to %s#%s%s is not suspendable", i, min.owner, min.name, min.desc);
            this.possiblyWarnAboutBlocking(min);
        }
        this.addCodeBlock(null, numIns);
    }

    private void possiblyWarnAboutBlocking(AbstractInsnNode ain) throws UnableToInstrumentException {
        MethodInsnNode min;
        int blockingId;
        if (ain instanceof MethodInsnNode && (blockingId = Classes.blockingCallIdx(min = (MethodInsnNode)ain)) >= 0 && !Classes.isAllowedToBlock(this.className, this.mn.name)) {
            int mask = 1 << blockingId;
            if (!this.db.isAllowBlocking()) {
                throw new UnableToInstrumentException("blocking call to " + min.owner + "#" + min.name + min.desc, this.className, this.mn.name, this.mn.desc);
            }
            if ((this.warnedAboutBlocking & mask) == 0) {
                this.warnedAboutBlocking |= mask;
                this.db.log(LogLevel.WARNING, "Method %s#%s%s contains potentially blocking call to " + min.owner + "#" + min.name + min.desc, this.className, this.mn.name, this.mn.desc);
            }
        }
    }

    public void accept(MethodVisitor mv, boolean hasAnnotation) {
        FrameInfo fi;
        int i;
        this.db.log(LogLevel.INFO, "Instrumenting method %s#%s%s", this.className, this.mn.name, this.mn.desc);
        boolean skipInstrumentation = this.canInstrumentationBeSkipped(this.suspCallsBcis);
        this.emitInstrumentedAnn(mv, skipInstrumentation);
        if (skipInstrumentation) {
            this.db.log(LogLevel.INFO, "[OPTIMIZE] Skipping instrumentation for method %s#%s%s", this.className, this.mn.name, this.mn.desc);
            this.mn.accept(mv);
            return;
        }
        this.collectCodeBlocks();
        boolean handleProxyInvocations = this.callsSuspendableSupers;
        mv.visitCode();
        Label lMethodStart = new Label();
        Label lMethodStart2 = new Label();
        Label lMethodEnd = new Label();
        Label lCatchSEE = new Label();
        Label lCatchUTE = new Label();
        Label lCatchAll = new Label();
        Label[] lMethodCalls = new Label[this.numCodeBlocks - 1];
        for (i = 1; i < this.numCodeBlocks; ++i) {
            lMethodCalls[i - 1] = new Label();
        }
        mv.visitInsn(1);
        mv.visitVarInsn(58, this.lvarInvocationReturnValue);
        mv.visitTryCatchBlock(lMethodStart, lMethodEnd, lCatchSEE, "co/paralleluniverse/fibers/SuspendExecution");
        mv.visitTryCatchBlock(lMethodStart, lMethodEnd, lCatchSEE, "co/paralleluniverse/fibers/RuntimeSuspendExecution");
        if (handleProxyInvocations) {
            mv.visitTryCatchBlock(lMethodStart, lMethodEnd, lCatchUTE, "java/lang/reflect/UndeclaredThrowableException");
        }
        Label[][] refInvokeTryCatch = new Label[this.numCodeBlocks - 1][];
        for (i = 1; i < this.numCodeBlocks; ++i) {
            fi = this.codeBlocks[i];
            AbstractInsnNode in = this.mn.instructions.get(fi.endInstruction);
            if (!(this.mn.instructions.get(fi.endInstruction) instanceof MethodInsnNode)) continue;
            MethodInsnNode min = (MethodInsnNode)in;
            if (!MethodDatabase.isReflectInvocation(min.owner, min.name)) continue;
            Label[] ls = new Label[3];
            for (int k = 0; k < 3; ++k) {
                ls[k] = new Label();
            }
            refInvokeTryCatch[i - 1] = ls;
            mv.visitTryCatchBlock(ls[0], ls[1], ls[2], "java/lang/reflect/InvocationTargetException");
        }
        for (Object o : this.mn.tryCatchBlocks) {
            TryCatchBlockNode tcb = (TryCatchBlockNode)o;
            if ("co/paralleluniverse/fibers/SuspendExecution".equals(tcb.type) && !hasAnnotation && !this.mn.name.startsWith("lambda$")) {
                throw new UnableToInstrumentException("catch for SuspendExecution", this.className, this.mn.name, this.mn.desc);
            }
            if (handleProxyInvocations && "java/lang/reflect/UndeclaredThrowableException".equals(tcb.type)) {
                throw new UnableToInstrumentException("catch for UndeclaredThrowableException", this.className, this.mn.name, this.mn.desc);
            }
            tcb.accept(mv);
        }
        if (this.mn.visibleParameterAnnotations != null) {
            InstrumentMethod.dumpParameterAnnotations(mv, this.mn.visibleParameterAnnotations, true);
        }
        if (this.mn.invisibleParameterAnnotations != null) {
            InstrumentMethod.dumpParameterAnnotations(mv, this.mn.invisibleParameterAnnotations, false);
        }
        if (this.mn.visibleAnnotations != null) {
            for (Object o : this.mn.visibleAnnotations) {
                AnnotationNode an = (AnnotationNode)o;
                an.accept(mv.visitAnnotation(an.desc, true));
            }
        }
        mv.visitTryCatchBlock(lMethodStart, lMethodEnd, lCatchAll, null);
        mv.visitMethodInsn(184, "co/paralleluniverse/fibers/Stack", "getStack", "()Lco/paralleluniverse/fibers/Stack;", false);
        mv.visitInsn(89);
        mv.visitVarInsn(58, this.lvarStack);
        mv.visitJumpInsn(198, lMethodStart);
        mv.visitVarInsn(25, this.lvarStack);
        this.emitStoreResumed(mv, true);
        mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "nextMethodEntry", "()I", false);
        mv.visitTableSwitchInsn(1, this.numCodeBlocks - 1, lMethodStart2, lMethodCalls);
        mv.visitLabel(lMethodStart2);
        mv.visitVarInsn(25, this.lvarStack);
        mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "isFirstInStackOrPushed", "()Z", false);
        mv.visitJumpInsn(154, lMethodStart);
        mv.visitInsn(1);
        mv.visitVarInsn(58, this.lvarStack);
        mv.visitLabel(lMethodStart);
        this.emitStoreResumed(mv, false);
        this.dumpCodeBlock(mv, 0, 0);
        for (int i2 = 1; i2 < this.numCodeBlocks; ++i2) {
            fi = this.codeBlocks[i2];
            AbstractInsnNode min = this.mn.instructions.get(fi.endInstruction);
            String owner = InstrumentMethod.getMethodOwner(min);
            String name = InstrumentMethod.getMethodName(min);
            String desc = InstrumentMethod.getMethodDesc(min);
            if (Classes.isYieldMethod(owner, name)) {
                if (min.getOpcode() != 184) {
                    throw new UnableToInstrumentException("invalid call to suspending method.", this.className, this.mn.name, this.mn.desc);
                }
                int numYieldArgs = TypeAnalyzer.getNumArguments(desc);
                boolean yieldReturnsValue = Type.getReturnType(desc) != Type.VOID_TYPE;
                this.emitStoreState(mv, i2, fi, numYieldArgs);
                this.emitStoreResumed(mv, false);
                min.accept(mv);
                if (yieldReturnsValue) {
                    mv.visitInsn(87);
                }
                mv.visitLabel(lMethodCalls[i2 - 1]);
                Label afterPostRestore = new Label();
                mv.visitVarInsn(21, this.lvarResumed);
                mv.visitJumpInsn(153, afterPostRestore);
                this.emitPostRestore(mv);
                mv.visitLabel(afterPostRestore);
                this.emitRestoreState(mv, i2, fi, numYieldArgs);
                if (yieldReturnsValue) {
                    mv.visitVarInsn(21, this.lvarResumed);
                }
                this.dumpCodeBlock(mv, i2, 1);
                continue;
            }
            Label lbl = new Label();
            mv.visitVarInsn(25, this.lvarStack);
            mv.visitJumpInsn(198, lbl);
            this.emitStoreState(mv, i2, fi, 0);
            this.emitStoreResumed(mv, false);
            mv.visitLabel(lMethodCalls[i2 - 1]);
            this.emitRestoreState(mv, i2, fi, 0);
            mv.visitLabel(lbl);
            if (MethodDatabase.isReflectInvocation(owner, name)) {
                Label[] ls = refInvokeTryCatch[i2 - 1];
                Label startTry = ls[0];
                Label endTry = ls[1];
                Label startCatch = ls[2];
                Label endCatch = new Label();
                Label notSuspendExecution = new Label();
                mv.visitLabel(startTry);
                min.accept(mv);
                mv.visitVarInsn(58, this.lvarInvocationReturnValue);
                mv.visitLabel(endTry);
                mv.visitJumpInsn(167, endCatch);
                mv.visitLabel(startCatch);
                mv.visitInsn(89);
                mv.visitMethodInsn(182, "java/lang/Throwable", "getCause", "()Ljava/lang/Throwable;", false);
                mv.visitTypeInsn(193, "co/paralleluniverse/fibers/SuspendExecution");
                mv.visitJumpInsn(153, notSuspendExecution);
                mv.visitMethodInsn(182, "java/lang/Throwable", "getCause", "()Ljava/lang/Throwable;", false);
                mv.visitLabel(notSuspendExecution);
                mv.visitInsn(191);
                mv.visitLabel(endCatch);
                mv.visitVarInsn(25, this.lvarInvocationReturnValue);
                this.dumpCodeBlock(mv, i2, 1);
                continue;
            }
            this.dumpCodeBlock(mv, i2, 0);
        }
        mv.visitLabel(lMethodEnd);
        if (handleProxyInvocations) {
            mv.visitLabel(lCatchUTE);
            mv.visitInsn(89);
            mv.visitMethodInsn(182, "java/lang/Throwable", "getCause", "()Ljava/lang/Throwable;", false);
            mv.visitTypeInsn(193, "co/paralleluniverse/fibers/SuspendExecution");
            mv.visitJumpInsn(153, lCatchAll);
            mv.visitMethodInsn(182, "java/lang/Throwable", "getCause", "()Ljava/lang/Throwable;", false);
            mv.visitJumpInsn(167, lCatchSEE);
        }
        mv.visitLabel(lCatchAll);
        this.emitPopMethod(mv);
        mv.visitLabel(lCatchSEE);
        mv.visitInsn(191);
        if (this.mn.localVariables != null) {
            for (Object o : this.mn.localVariables) {
                ((LocalVariableNode)o).accept(mv);
            }
        }
        mv.visitMaxs(this.mn.maxStack + 6, this.mn.maxLocals + 3 + this.additionalLocals);
        mv.visitEnd();
    }

    private boolean canInstrumentationBeSkipped(int[] susCallsIndexes) {
        this.db.log(LogLevel.DEBUG, "[OPTIMIZE] Examining method %s#%s%s with susCallsIndexes=%s", this.className, this.mn.name, this.mn.desc, Arrays.toString(susCallsIndexes));
        return this.isForwardingToSuspendable(susCallsIndexes);
    }

    private boolean isForwardingToSuspendable(int[] susCallsBcis) {
        AbstractInsnNode ins;
        int i;
        if (susCallsBcis.length != 1) {
            return false;
        }
        int susCallBci = susCallsBcis[0];
        AbstractInsnNode susCall = this.mn.instructions.get(susCallBci);
        assert (this.isSuspendableCall(susCall));
        if (Classes.isYieldMethod(InstrumentMethod.getMethodOwner(susCall), InstrumentMethod.getMethodName(susCall))) {
            return false;
        }
        if (MethodDatabase.isReflectInvocation(InstrumentMethod.getMethodOwner(susCall), InstrumentMethod.getMethodName(susCall))) {
            return false;
        }
        if (this.hasSuspendableTryCatchBlocksAround(susCallBci)) {
            return false;
        }
        for (i = 0; i < susCallBci; ++i) {
            ins = this.mn.instructions.get(i);
            if (ins.getType() == 5 || ins.getType() == 6) {
                return false;
            }
            if (ins.getType() == 4) {
                return false;
            }
            if (ins instanceof JumpInsnNode && this.mn.instructions.indexOf(((JumpInsnNode)ins).label) <= i) {
                return false;
            }
            if (this.db.isAllowMonitors() || ins.getOpcode() != 194 && ins.getOpcode() != 195) continue;
            return false;
        }
        for (i = susCallBci + 1; i <= this.mn.instructions.size() - 1; ++i) {
            ins = this.mn.instructions.get(i);
            if (ins instanceof JumpInsnNode && this.mn.instructions.indexOf(((JumpInsnNode)ins).label) <= susCallBci) {
                return false;
            }
            if (!(this.db.isAllowMonitors() || ins.getOpcode() != 194 && ins.getOpcode() != 195)) {
                return false;
            }
            if (this.db.isAllowBlocking() || !(ins instanceof MethodInsnNode) || Classes.blockingCallIdx((MethodInsnNode)ins) == -1) continue;
            return false;
        }
        return true;
    }

    private boolean hasSuspendableTryCatchBlocksAround(int bci) {
        for (TryCatchBlockNode tcb : this.mn.tryCatchBlocks) {
            if (this.mn.instructions.indexOf(tcb.start) > bci || this.mn.instructions.indexOf(tcb.end) < bci || !"java/lang/Throwable".equals(tcb.type) && !"java/lang/Exception".equals(tcb.type) && !"java/lang/RuntimeException".equals(tcb.type) && !"co/paralleluniverse/fibers/RuntimeSuspendExecution".equals(tcb.type) && !"co/paralleluniverse/fibers/SuspendExecution".equals(tcb.type)) continue;
            return true;
        }
        return false;
    }

    private void emitInstrumentedAnn(MethodVisitor mv, boolean skip) {
        StringBuilder sb = new StringBuilder();
        AnnotationVisitor instrumentedAV = mv.visitAnnotation(Classes.ALREADY_INSTRUMENTED_DESC, true);
        sb.append("@Instrumented(");
        AnnotationVisitor linesAV = instrumentedAV.visitArray("suspendableCallSites");
        sb.append("suspendableCallSites=[");
        for (int i = 0; i < this.suspCallsSourceLines.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            int l = this.suspCallsSourceLines[i];
            linesAV.visit("", l);
            sb.append(l);
        }
        linesAV.visitEnd();
        sb.append("],");
        instrumentedAV.visit("methodStart", this.startSourceLine);
        instrumentedAV.visit("methodEnd", this.endSourceLine);
        instrumentedAV.visit("methodOptimized", skip);
        instrumentedAV.visitEnd();
        sb.append("methodStart=").append(this.startSourceLine).append(",");
        sb.append("methodEnd=").append(this.endSourceLine).append(",");
        sb.append("methodOptimized=").append(skip);
        sb.append(")");
        this.db.log(LogLevel.DEBUG, "Annotating method %s#%s%s with %s", this.className, this.mn.name, this.mn.desc, sb);
    }

    private void dumpStack(MethodVisitor mv) {
        mv.visitMethodInsn(184, "java/lang/Thread", "dumpStack", "()V", false);
    }

    private FrameInfo addCodeBlock(Frame f, int end) {
        FrameInfo fi;
        if (++this.numCodeBlocks == this.codeBlocks.length) {
            FrameInfo[] newArray = new FrameInfo[this.numCodeBlocks * 2];
            System.arraycopy(this.codeBlocks, 0, newArray, 0, this.codeBlocks.length);
            this.codeBlocks = newArray;
        }
        this.codeBlocks[this.numCodeBlocks] = fi = new FrameInfo(f, this.firstLocal, end, this.mn.instructions, this.db);
        return fi;
    }

    private void emitStoreResumed(MethodVisitor mv, boolean value) {
        mv.visitInsn(value ? 4 : 3);
        mv.visitVarInsn(54, this.lvarResumed);
    }

    private int getLabelIdx(LabelNode l) {
        int idx = l instanceof BlockLabelNode ? ((BlockLabelNode)l).idx : this.mn.instructions.indexOf(l);
        int type;
        while ((type = this.mn.instructions.get(idx).getType()) == 8 || type == 15) {
            ++idx;
        }
        return idx;
    }

    private void splitTryCatch(FrameInfo fi) {
        for (int i = 0; i < this.mn.tryCatchBlocks.size(); ++i) {
            TryCatchBlockNode tcb = (TryCatchBlockNode)this.mn.tryCatchBlocks.get(i);
            int start = this.getLabelIdx(tcb.start);
            int end = this.getLabelIdx(tcb.end);
            if (start > fi.endInstruction || end < fi.endInstruction) continue;
            this.db.log(LogLevel.DEBUG, "Splitting try-catch in %s, block %d call at instruction %d", this.mn.name, i, fi.endInstruction);
            if (start == fi.endInstruction) {
                tcb.start = fi.createAfterLabel();
                continue;
            }
            if (end > fi.endInstruction) {
                TryCatchBlockNode tcb2 = new TryCatchBlockNode(fi.createAfterLabel(), tcb.end, tcb.handler, tcb.type);
                this.mn.tryCatchBlocks.add(i + 1, tcb2);
            }
            tcb.end = fi.createBeforeLabel();
        }
    }

    private void dumpCodeBlock(MethodVisitor mv, int idx, int skip) {
        int start = this.codeBlocks[idx].endInstruction;
        int end = this.codeBlocks[idx + 1].endInstruction;
        for (int i = start + skip; i < end; ++i) {
            AbstractInsnNode ins = this.mn.instructions.get(i);
            switch (ins.getOpcode()) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    this.emitPopMethod(mv);
                    break;
                }
                case 194: 
                case 195: {
                    if (!this.db.isAllowMonitors()) {
                        if (this.className.equals("clojure/lang/LazySeq")) break;
                        throw new UnableToInstrumentException("synchronization", this.className, this.mn.name, this.mn.desc);
                    }
                    if (this.warnedAboutMonitors) break;
                    this.warnedAboutMonitors = true;
                    this.db.log(LogLevel.WARNING, "Method %s#%s%s contains synchronization", this.className, this.mn.name, this.mn.desc);
                    break;
                }
                case 183: {
                    MethodInsnNode min = (MethodInsnNode)ins;
                    if (!"<init>".equals(min.name)) break;
                    int argSize = TypeAnalyzer.getNumArguments(min.desc);
                    Frame frame = this.frames[i];
                    int stackIndex = frame.getStackSize() - argSize - 1;
                    Value thisValue = frame.getStack(stackIndex);
                    if (stackIndex >= 1 && InstrumentMethod.isNewValue(thisValue, true) && InstrumentMethod.isNewValue(frame.getStack(stackIndex - 1), false)) {
                        if (!InstrumentMethod.isOmitted((NewValue)thisValue)) break;
                        this.emitNewAndDup(mv, frame, stackIndex, min);
                        break;
                    }
                    this.db.log(LogLevel.WARNING, "Expected to find a NewValue on stack index %d: %s", stackIndex, frame);
                }
            }
            ins.accept(mv);
        }
    }

    private static void dumpParameterAnnotations(MethodVisitor mv, List[] parameterAnnotations, boolean visible) {
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (parameterAnnotations[i] == null) continue;
            for (Object o : parameterAnnotations[i]) {
                AnnotationNode an = (AnnotationNode)o;
                an.accept(mv.visitParameterAnnotation(i, an.desc, visible));
            }
        }
    }

    private static void emitConst(MethodVisitor mv, int value) {
        if (value >= -1 && value <= 5) {
            mv.visitInsn(3 + value);
        } else if ((byte)value == value) {
            mv.visitIntInsn(16, value);
        } else if ((short)value == value) {
            mv.visitIntInsn(17, value);
        } else {
            mv.visitLdcInsn(value);
        }
    }

    private static void emitConst(MethodVisitor mv, String value) {
        mv.visitLdcInsn(value);
    }

    private void emitNewAndDup(MethodVisitor mv, Frame frame, int stackIndex, MethodInsnNode min) {
        BasicValue v;
        int i;
        int arguments = frame.getStackSize() - stackIndex - 1;
        int neededLocals = 0;
        for (i = arguments; i >= 1; --i) {
            v = (BasicValue)frame.getStack(stackIndex + i);
            mv.visitVarInsn(v.getType().getOpcode(54), this.lvarStack + 3 + neededLocals);
            neededLocals += v.getSize();
        }
        if (this.additionalLocals < neededLocals) {
            this.additionalLocals = neededLocals;
        }
        this.db.log(LogLevel.DEBUG, "Inserting NEW & DUP for constructor call %s%s with %d arguments (%d locals)", min.owner, min.desc, arguments, neededLocals);
        ((NewValue)frame.getStack((int)(stackIndex - 1))).insn.accept(mv);
        ((NewValue)frame.getStack((int)stackIndex)).insn.accept(mv);
        for (i = 1; i <= arguments; ++i) {
            v = (BasicValue)frame.getStack(stackIndex + i);
            mv.visitVarInsn(v.getType().getOpcode(21), this.lvarStack + 3 + (neededLocals -= v.getSize()));
        }
    }

    private void emitPopMethod(MethodVisitor mv) {
        Label lbl = new Label();
        mv.visitVarInsn(25, this.lvarStack);
        mv.visitJumpInsn(198, lbl);
        mv.visitVarInsn(25, this.lvarStack);
        mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "popMethod", "()V", false);
        mv.visitLabel(lbl);
    }

    private void emitStoreState(MethodVisitor mv, int idx, FrameInfo fi, int numArgsToPreserve) {
        int slotIdx;
        BasicValue v;
        if (idx > 16383) {
            throw new IllegalArgumentException("Entry index (PC) " + idx + " greater than maximum of " + 16383 + " in " + this.className + "." + this.mn.name + this.mn.desc);
        }
        if (fi.numSlots > 65535) {
            throw new IllegalArgumentException("Number of slots required " + fi.numSlots + " greater than maximum of " + 65535 + " in " + this.className + "." + this.mn.name + this.mn.desc);
        }
        Frame f = this.frames[fi.endInstruction];
        if (fi.lBefore != null) {
            fi.lBefore.accept(mv);
        }
        mv.visitVarInsn(25, this.lvarStack);
        InstrumentMethod.emitConst(mv, idx);
        InstrumentMethod.emitConst(mv, fi.numSlots);
        mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "pushMethod", "(II)V", false);
        int i = f.getStackSize();
        while (i-- > 0) {
            v = (BasicValue)f.getStack(i);
            if (InstrumentMethod.isOmitted(v)) continue;
            if (!InstrumentMethod.isNullType(v)) {
                slotIdx = fi.stackSlotIndices[i];
                assert (slotIdx >= 0 && slotIdx < fi.numSlots);
                this.emitStoreValue(mv, v, this.lvarStack, slotIdx, -1);
                continue;
            }
            this.db.log(LogLevel.DEBUG, "NULL stack entry: type=%s size=%d", v.getType(), v.getSize());
            mv.visitInsn(87);
        }
        for (i = this.firstLocal; i < f.getLocals(); ++i) {
            v = (BasicValue)f.getLocal(i);
            if (InstrumentMethod.isNullType(v)) continue;
            mv.visitVarInsn(v.getType().getOpcode(21), i);
            slotIdx = fi.localSlotIndices[i];
            assert (slotIdx >= 0 && slotIdx < fi.numSlots);
            this.emitStoreValue(mv, v, this.lvarStack, slotIdx, i);
        }
        for (i = f.getStackSize() - numArgsToPreserve; i < f.getStackSize(); ++i) {
            v = (BasicValue)f.getStack(i);
            if (InstrumentMethod.isOmitted(v)) continue;
            if (!InstrumentMethod.isNullType(v)) {
                slotIdx = fi.stackSlotIndices[i];
                assert (slotIdx >= 0 && slotIdx < fi.numSlots);
                this.emitRestoreValue(mv, v, this.lvarStack, slotIdx, -1);
                continue;
            }
            mv.visitInsn(1);
        }
    }

    private void emitRestoreState(MethodVisitor mv, int idx, FrameInfo fi, int numArgsPreserved) {
        int slotIdx;
        BasicValue v;
        int i;
        Frame f = this.frames[fi.endInstruction];
        for (i = this.firstLocal; i < f.getLocals(); ++i) {
            v = (BasicValue)f.getLocal(i);
            if (!InstrumentMethod.isNullType(v)) {
                slotIdx = fi.localSlotIndices[i];
                assert (slotIdx >= 0 && slotIdx < fi.numSlots);
                this.emitRestoreValue(mv, v, this.lvarStack, slotIdx, i);
                mv.visitVarInsn(v.getType().getOpcode(54), i);
                continue;
            }
            if (v == BasicValue.UNINITIALIZED_VALUE) continue;
            mv.visitInsn(1);
            mv.visitVarInsn(58, i);
        }
        for (i = 0; i < f.getStackSize() - numArgsPreserved; ++i) {
            v = (BasicValue)f.getStack(i);
            if (InstrumentMethod.isOmitted(v)) continue;
            if (!InstrumentMethod.isNullType(v)) {
                slotIdx = fi.stackSlotIndices[i];
                assert (slotIdx >= 0 && slotIdx < fi.numSlots);
                this.emitRestoreValue(mv, v, this.lvarStack, slotIdx, -1);
                continue;
            }
            mv.visitInsn(1);
        }
        if (fi.lAfter != null) {
            fi.lAfter.accept(mv);
        }
    }

    private void emitPostRestore(MethodVisitor mv) {
        mv.visitVarInsn(25, this.lvarStack);
        mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "postRestore", "()V", false);
    }

    private void emitPreemptionPoint(MethodVisitor mv, int type) {
        mv.visitVarInsn(25, this.lvarStack);
        switch (type) {
            case 0: {
                mv.visitInsn(3);
                break;
            }
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 3: {
                mv.visitInsn(6);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported type: " + type));
            }
        }
        mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "preemptionPoint", "(I)V", false);
    }

    private void emitStoreValue(MethodVisitor mv, BasicValue v, int lvarStack, int idx, int lvar) throws InternalError, IndexOutOfBoundsException {
        String desc;
        switch (v.getType().getSort()) {
            case 9: 
            case 10: {
                desc = "(Ljava/lang/Object;Lco/paralleluniverse/fibers/Stack;I)V";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                desc = "(ILco/paralleluniverse/fibers/Stack;I)V";
                break;
            }
            case 6: {
                desc = "(FLco/paralleluniverse/fibers/Stack;I)V";
                break;
            }
            case 7: {
                desc = "(JLco/paralleluniverse/fibers/Stack;I)V";
                break;
            }
            case 8: {
                desc = "(DLco/paralleluniverse/fibers/Stack;I)V";
                break;
            }
            default: {
                throw new InternalError("Unexpected type: " + v.getType());
            }
        }
        mv.visitVarInsn(25, lvarStack);
        InstrumentMethod.emitConst(mv, idx);
        mv.visitMethodInsn(184, "co/paralleluniverse/fibers/Stack", "push", desc, false);
    }

    private void emitRestoreValue(MethodVisitor mv, BasicValue v, int lvarStack, int idx, int lvar) {
        mv.visitVarInsn(25, lvarStack);
        InstrumentMethod.emitConst(mv, idx);
        switch (v.getType().getSort()) {
            case 10: {
                String internalName = v.getType().getInternalName();
                mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "getObject", "(I)Ljava/lang/Object;", false);
                if (internalName.equals("java/lang/Object")) break;
                mv.visitTypeInsn(192, internalName);
                break;
            }
            case 9: {
                mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "getObject", "(I)Ljava/lang/Object;", false);
                mv.visitTypeInsn(192, v.getType().getDescriptor());
                break;
            }
            case 3: {
                mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "getInt", "(I)I", false);
                mv.visitInsn(145);
                break;
            }
            case 4: {
                mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "getInt", "(I)I", false);
                mv.visitInsn(147);
                break;
            }
            case 2: {
                mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "getInt", "(I)I", false);
                mv.visitInsn(146);
                break;
            }
            case 1: 
            case 5: {
                mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "getInt", "(I)I", false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "getFloat", "(I)F", false);
                break;
            }
            case 7: {
                mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "getLong", "(I)J", false);
                break;
            }
            case 8: {
                mv.visitMethodInsn(182, "co/paralleluniverse/fibers/Stack", "getDouble", "(I)D", false);
                break;
            }
            default: {
                throw new InternalError("Unexpected type: " + v.getType());
            }
        }
    }

    static boolean isNullType(BasicValue v) {
        return v == BasicValue.UNINITIALIZED_VALUE || v.isReference() && v.getType().getInternalName().equals("null");
    }

    static boolean isOmitted(BasicValue v) {
        if (v instanceof NewValue) {
            return ((NewValue)v).omitted;
        }
        return false;
    }

    static boolean isNewValue(Value v, boolean dupped) {
        if (v instanceof NewValue) {
            return ((NewValue)v).isDupped == dupped;
        }
        return false;
    }

    private static String getMethodOwner(AbstractInsnNode min) {
        return min instanceof MethodInsnNode ? ((MethodInsnNode)min).owner : null;
    }

    private static String getMethodName(AbstractInsnNode min) {
        return min instanceof MethodInsnNode ? ((MethodInsnNode)min).name : (min instanceof InvokeDynamicInsnNode ? ((InvokeDynamicInsnNode)min).name : null);
    }

    private static String getMethodDesc(AbstractInsnNode min) {
        return min instanceof MethodInsnNode ? ((MethodInsnNode)min).desc : (min instanceof InvokeDynamicInsnNode ? ((InvokeDynamicInsnNode)min).desc : null);
    }

    private void println(MethodVisitor mv, String prefix, int refVar) {
        mv.visitFieldInsn(178, "java/lang/System", "err", "Ljava/io/PrintStream;");
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitMethodInsn(184, "java/lang/Thread", "currentThread", "()Ljava/lang/Thread;", false);
        mv.visitMethodInsn(182, "java/lang/Thread", "getName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn(" " + prefix);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn(" var " + refVar + ":");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitVarInsn(25, refVar);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
    }

    private void println(MethodVisitor mv, String prefix) {
        mv.visitInsn(89);
        mv.visitFieldInsn(178, "java/lang/System", "err", "Ljava/io/PrintStream;");
        mv.visitInsn(95);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitMethodInsn(184, "java/lang/Thread", "currentThread", "()Ljava/lang/Thread;", false);
        mv.visitMethodInsn(182, "java/lang/Thread", "getName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn(" " + prefix);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitInsn(95);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
    }

    static class FrameInfo {
        static final FrameInfo FIRST = new FrameInfo(null, 0, 0, null, null);
        final int endInstruction;
        final int numSlots;
        final int numObjSlots;
        final int[] localSlotIndices;
        final int[] stackSlotIndices;
        BlockLabelNode lBefore;
        BlockLabelNode lAfter;

        FrameInfo(Frame f, int firstLocal, int endInstruction, InsnList insnList, MethodDatabase db) {
            this.endInstruction = endInstruction;
            int idxObj = 0;
            int idxPrim = 0;
            if (f != null) {
                BasicValue v;
                int i;
                this.stackSlotIndices = new int[f.getStackSize()];
                for (i = 0; i < f.getStackSize(); ++i) {
                    v = (BasicValue)f.getStack(i);
                    if (v instanceof NewValue) {
                        NewValue newValue = (NewValue)v;
                        if (db.isDebug()) {
                            db.log(LogLevel.DEBUG, "Omit value from stack idx %d at instruction %d with type %s generated by %s", i, endInstruction, v, newValue.formatInsn());
                        }
                        if (!newValue.omitted) {
                            newValue.omitted = true;
                            if (db.isDebug()) {
                                db.log(LogLevel.DEBUG, "Omitting instruction %d: %s", insnList.indexOf(newValue.insn), newValue.formatInsn());
                            }
                            insnList.set(newValue.insn, new OmittedInstruction(newValue.insn));
                        }
                        this.stackSlotIndices[i] = -666;
                        continue;
                    }
                    if (!InstrumentMethod.isNullType(v)) {
                        if (v.isReference()) {
                            this.stackSlotIndices[i] = idxObj++;
                            continue;
                        }
                        this.stackSlotIndices[i] = idxPrim++;
                        continue;
                    }
                    this.stackSlotIndices[i] = -666;
                }
                this.localSlotIndices = new int[f.getLocals()];
                for (i = firstLocal; i < f.getLocals(); ++i) {
                    v = (BasicValue)f.getLocal(i);
                    if (!InstrumentMethod.isNullType(v)) {
                        if (v.isReference()) {
                            this.localSlotIndices[i] = idxObj++;
                            continue;
                        }
                        this.localSlotIndices[i] = idxPrim++;
                        continue;
                    }
                    this.localSlotIndices[i] = -666;
                }
            } else {
                this.stackSlotIndices = null;
                this.localSlotIndices = null;
            }
            this.numSlots = Math.max(idxPrim, idxObj);
            this.numObjSlots = idxObj;
        }

        public LabelNode createBeforeLabel() {
            if (this.lBefore == null) {
                this.lBefore = new BlockLabelNode(this.endInstruction);
            }
            return this.lBefore;
        }

        public LabelNode createAfterLabel() {
            if (this.lAfter == null) {
                this.lAfter = new BlockLabelNode(this.endInstruction);
            }
            return this.lAfter;
        }
    }

    static class BlockLabelNode
    extends LabelNode {
        final int idx;

        BlockLabelNode(int idx) {
            this.idx = idx;
        }
    }

    private static class OmittedInstruction
    extends AbstractInsnNode {
        private final AbstractInsnNode orgInsn;

        public OmittedInstruction(AbstractInsnNode orgInsn) {
            super(orgInsn.getOpcode());
            this.orgInsn = orgInsn;
        }

        @Override
        public int getType() {
            return this.orgInsn.getType();
        }

        @Override
        public void accept(MethodVisitor cv) {
        }

        @Override
        public AbstractInsnNode clone(Map labels) {
            return new OmittedInstruction(this.orgInsn.clone(labels));
        }
    }
}

