/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.impl.ConfigHttpClientManager;
import com.alibaba.nacos.client.config.impl.ServerListManager;
import com.alibaba.nacos.client.config.impl.SpasAdapter;
import com.alibaba.nacos.client.identify.StsConfig;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class ConfigTransportClient {
    private static final Logger LOGGER = LogUtils.logger(ConfigTransportClient.class);
    String encode;
    String tenant;
    ScheduledExecutorService executor;
    final ServerListManager serverListManager;
    private int maxRetry = 3;
    private final long securityInfoRefreshIntervalMills = TimeUnit.SECONDS.toMillis(5L);
    protected SecurityProxy securityProxy;
    private String accessKey;
    protected String secretKey;
    private volatile StsCredential stsCredential;

    public ConfigTransportClient(Properties properties, ServerListManager serverListManager) {
        String encodeTmp = properties.getProperty("encode");
        this.encode = StringUtils.isBlank(encodeTmp) ? "UTF-8" : encodeTmp.trim();
        this.tenant = properties.getProperty("namespace");
        this.serverListManager = serverListManager;
        this.securityProxy = new SecurityProxy(properties, ConfigHttpClientManager.getInstance().getNacosRestTemplate());
    }

    protected Map<String, String> getSpasHeaders() throws Exception {
        HashMap<String, String> spasHeaders = new HashMap<String, String>(2);
        if (StsConfig.getInstance().isStsOn()) {
            StsCredential stsCredential = this.getStsCredential();
            this.accessKey = stsCredential.accessKeyId;
            this.secretKey = stsCredential.accessKeySecret;
            spasHeaders.put("Spas-SecurityToken", stsCredential.securityToken);
        }
        if (StringUtils.isNotEmpty(this.accessKey) && StringUtils.isNotEmpty(this.secretKey)) {
            spasHeaders.put("Spas-AccessKey", this.accessKey);
        }
        return spasHeaders;
    }

    protected Map<String, String> getSecurityHeaders() {
        if (StringUtils.isBlank(this.securityProxy.getAccessToken())) {
            return null;
        }
        HashMap<String, String> spasHeaders = new HashMap<String, String>(2);
        spasHeaders.put("accessToken", this.securityProxy.getAccessToken());
        return spasHeaders;
    }

    protected Map<String, String> getCommonHeader() {
        HashMap<String, String> headers = new HashMap<String, String>(16);
        String ts = String.valueOf(System.currentTimeMillis());
        String token = MD5Utils.md5Hex(ts + ParamUtil.getAppKey(), "UTF-8");
        headers.put("Client-AppName", ParamUtil.getAppName());
        headers.put("Client-RequestTS", ts);
        headers.put("Client-RequestToken", token);
        headers.put("exConfigInfo", "true");
        headers.put("charset", this.encode);
        return headers;
    }

    public String getAccessToken() {
        return this.securityProxy.getAccessToken();
    }

    private StsCredential getStsCredential() throws Exception {
        StsCredential stsCredentialTmp;
        boolean cacheSecurityCredentials = StsConfig.getInstance().isCacheSecurityCredentials();
        if (cacheSecurityCredentials && this.stsCredential != null) {
            int timeToRefreshInMillisecond;
            long currentTime = System.currentTimeMillis();
            long expirationTime = this.stsCredential.expiration.getTime();
            if (expirationTime - currentTime > (long)(timeToRefreshInMillisecond = StsConfig.getInstance().getTimeToRefreshInMillisecond())) {
                return this.stsCredential;
            }
        }
        String stsResponse = ConfigTransportClient.getStsResponse();
        this.stsCredential = stsCredentialTmp = JacksonUtils.toObj(stsResponse, new TypeReference<StsCredential>(){});
        LOGGER.info("[getSTSCredential] code:{}, accessKeyId:{}, lastUpdated:{}, expiration:{}", new Object[]{this.stsCredential.getCode(), this.stsCredential.getAccessKeyId(), this.stsCredential.getLastUpdated(), this.stsCredential.getExpiration()});
        return this.stsCredential;
    }

    private static String getStsResponse() throws Exception {
        String securityCredentials = StsConfig.getInstance().getSecurityCredentials();
        if (securityCredentials != null) {
            return securityCredentials;
        }
        String securityCredentialsUrl = StsConfig.getInstance().getSecurityCredentialsUrl();
        try {
            HttpRestResult result = ConfigHttpClientManager.getInstance().getNacosRestTemplate().get(securityCredentialsUrl, Header.EMPTY, Query.EMPTY, (Type)((Object)String.class));
            if (!result.ok()) {
                LOGGER.error("can not get security credentials, securityCredentialsUrl: {}, responseCode: {}, response: {}", new Object[]{securityCredentialsUrl, result.getCode(), result.getMessage()});
                throw new NacosException(500, "can not get security credentials, responseCode: " + result.getCode() + ", response: " + result.getMessage());
            }
            return (String)result.getData();
        }
        catch (Exception e) {
            LOGGER.error("can not get security credentials", (Throwable)e);
            throw e;
        }
    }

    private void initAkSk(Properties properties) {
        String ak;
        String ramRoleName = properties.getProperty("ramRoleName");
        if (!StringUtils.isBlank(ramRoleName)) {
            StsConfig.getInstance().setRamRoleName(ramRoleName);
        }
        this.accessKey = StringUtils.isBlank(ak = properties.getProperty("accessKey")) ? SpasAdapter.getAk() : ak;
        String sk = properties.getProperty("secretKey");
        this.secretKey = StringUtils.isBlank(sk) ? SpasAdapter.getSk() : sk;
    }

    private void initMaxRetry(Properties properties) {
        this.maxRetry = ConvertUtils.toInt(String.valueOf(properties.get("maxRetry")), 3);
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void start() throws NacosException {
        if (this.securityProxy.isEnabled()) {
            this.securityProxy.login(this.serverListManager.getServerUrls());
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ConfigTransportClient.this.securityProxy.login(ConfigTransportClient.this.serverListManager.getServerUrls());
                }
            }, 0L, this.securityInfoRefreshIntervalMills, TimeUnit.MILLISECONDS);
        }
        this.startInternal();
    }

    public abstract void startInternal() throws NacosException;

    public abstract String getName();

    public String getEncode() {
        return this.encode;
    }

    public String getTenant() {
        return this.tenant;
    }

    public abstract void notifyListenConfig();

    public abstract void executeConfigListen();

    public abstract void removeCache(String var1, String var2);

    public abstract String[] queryConfig(String var1, String var2, String var3, long var4, boolean var6) throws NacosException;

    public abstract boolean publishConfig(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws NacosException;

    public abstract boolean removeConfig(String var1, String var2, String var3, String var4) throws NacosException;

    private static class StsCredential {
        @JsonProperty(value="AccessKeyId")
        private String accessKeyId;
        @JsonProperty(value="AccessKeySecret")
        private String accessKeySecret;
        @JsonProperty(value="Expiration")
        private Date expiration;
        @JsonProperty(value="SecurityToken")
        private String securityToken;
        @JsonProperty(value="LastUpdated")
        private Date lastUpdated;
        @JsonProperty(value="Code")
        private String code;

        private StsCredential() {
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public Date getExpiration() {
            return this.expiration;
        }

        public Date getLastUpdated() {
            return this.lastUpdated;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return "STSCredential{accessKeyId='" + this.accessKeyId + '\'' + ", accessKeySecret='" + this.accessKeySecret + '\'' + ", expiration=" + this.expiration + ", securityToken='" + this.securityToken + '\'' + ", lastUpdated=" + this.lastUpdated + ", code='" + this.code + '\'' + '}';
        }
    }
}

