/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.zookeeper;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ConnectStringParser;
import org.apache.zookeeper.client.HostProvider;
import org.apache.zookeeper.client.StaticHostProvider;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ZooKeeperx
implements IZkConnection {
    private static final String SERVER_COMMA = ";";
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperx.class);
    private static final Field clientCnxnField = ReflectionUtils.findField(ZooKeeper.class, (String)"cnxn");
    private static final Field hostProviderField = ReflectionUtils.findField(ClientCnxn.class, (String)"hostProvider");
    private static final Field serverAddressesField = ReflectionUtils.findField(StaticHostProvider.class, (String)"serverAddresses");
    private static final int DEFAULT_SESSION_TIMEOUT = 90000;
    private ZooKeeper _zk = null;
    private Lock _zookeeperLock = new ReentrantLock();
    private final List<String> _servers;
    private final int _sessionTimeOut;

    public ZooKeeperx(String zkServers) {
        this(zkServers, 90000);
    }

    public ZooKeeperx(String zkServers, int sessionTimeOut) {
        this._servers = Arrays.asList(StringUtils.split((String)zkServers, (String)SERVER_COMMA));
        this._sessionTimeOut = sessionTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Watcher watcher) {
        this._zookeeperLock.lock();
        try {
            if (this._zk != null) {
                throw new IllegalStateException("zk client has already been started");
            }
            try {
                logger.debug("Creating new ZookKeeper instance to connect to " + this._servers + ".");
                this._zk = new ZooKeeper(this._servers.get(0), this._sessionTimeOut, watcher);
                this.configMutliCluster(this._zk);
            }
            catch (IOException e) {
                throw new ZkException("Unable to connect to " + this._servers, (Throwable)e);
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        this._zookeeperLock.lock();
        try {
            if (this._zk != null) {
                logger.debug("Closing ZooKeeper connected to " + this._servers);
                this._zk.close();
                this._zk = null;
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    public String create(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        return this._zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    public void delete(String path) throws InterruptedException, KeeperException {
        this._zk.delete(path, -1);
    }

    public boolean exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.exists(path, watch) != null;
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.getChildren(path, watch);
    }

    public byte[] readData(String path, Stat stat, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.getData(path, watch, stat);
    }

    public void writeData(String path, byte[] data) throws KeeperException, InterruptedException {
        this.writeData(path, data, -1);
    }

    public void writeData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        this._zk.setData(path, data, version);
    }

    public ZooKeeper.States getZookeeperState() {
        return this._zk != null ? this._zk.getState() : null;
    }

    public ZooKeeper getZookeeper() {
        return this._zk;
    }

    public long getCreateTime(String path) throws KeeperException, InterruptedException {
        Stat stat = this._zk.exists(path, false);
        if (stat != null) {
            return stat.getCtime();
        }
        return -1L;
    }

    public String getServers() {
        return StringUtils.join(this._servers, (String)SERVER_COMMA);
    }

    public void configMutliCluster(ZooKeeper zk) {
        if (this._servers.size() == 1) {
            return;
        }
        String cluster1 = this._servers.get(0);
        try {
            if (this._servers.size() > 1) {
                ReflectionUtils.makeAccessible((Field)clientCnxnField);
                ReflectionUtils.makeAccessible((Field)hostProviderField);
                ReflectionUtils.makeAccessible((Field)serverAddressesField);
                for (int i = 1; i < this._servers.size(); ++i) {
                    String cluster = this._servers.get(i);
                    ClientCnxn cnxn = (ClientCnxn)ReflectionUtils.getField((Field)clientCnxnField, (Object)zk);
                    HostProvider hostProvider = (HostProvider)ReflectionUtils.getField((Field)hostProviderField, (Object)cnxn);
                    List serverAddrs = (List)ReflectionUtils.getField((Field)serverAddressesField, (Object)hostProvider);
                    serverAddrs.addAll(new ConnectStringParser(cluster).getServerAddresses());
                }
            }
        }
        catch (Exception e) {
            try {
                if (zk != null) {
                    zk.close();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            throw new ZkException("zookeeper_create_error, serveraddrs=" + cluster1, (Throwable)e);
        }
    }
}

