/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.interceptor.httpRequest;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.provider.AnonymousCredentialProvider;
import com.aliyun.auth.signature.SignerParams;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.EncodeUtil;
import com.aliyun.core.utils.ParseUtil;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.auth.V3SignatureComposer;
import com.aliyun.sdk.gateway.pop.auth.signer.PopSigner;
import darabonba.core.TeaConfiguration;
import darabonba.core.TeaPair;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.HttpRequestInterceptor;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.utils.CommonUtil;
import darabonba.core.utils.ModelUtil;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class V3HttpReqInterceptor
implements HttpRequestInterceptor {
    private final ClientLogger logger = new ClientLogger(V3HttpReqInterceptor.class);

    public HttpRequest modifyHttpRequest(InterceptorContext context, AttributeMap attributes) {
        this.logger.info("Request pre-process begin.");
        TeaRequest request = context.teaRequest();
        HttpRequest httpRequest = context.httpRequest();
        TeaConfiguration configuration = context.configuration();
        ClientConfiguration clientConfiguration = configuration.clientConfiguration();
        PopSigner signer = (PopSigner)clientConfiguration.option(ClientOption.SIGNER);
        if (signer.getSignerVersion() != SignatureVersion.V3) {
            return httpRequest;
        }
        HttpMethod method = Optional.ofNullable(configuration.method()).orElseGet(() -> ((TeaRequest)request).method());
        Map headers = CommonUtil.merge(String.class, (Object[])new Object[]{CommonUtil.buildMap((TeaPair[])new TeaPair[]{new TeaPair("x-acs-signature-nonce", (Object)CommonUtil.getNonce()), new TeaPair("x-acs-date", (Object)CommonUtil.getTimestamp())}), request.headers().toMap()});
        Map query = request.query();
        byte[] body = null;
        String hashedRequestPayload = EncodeUtil.hexEncode((byte[])signer.hash(StringUtils.toBytes((String)"")));
        if (!CommonUtil.isUnset((Object)request.stream())) {
            body = ParseUtil.readAsBytes((InputStream)request.stream());
            hashedRequestPayload = EncodeUtil.hexEncode((byte[])signer.hash(body));
            headers.put("content-type", "application/octet-stream");
        } else if (!CommonUtil.isUnset((Object)request.body())) {
            if (request.reqBodyType().equals("json")) {
                body = StringUtils.toBytes((String)ParseUtil.toJSONString((Object)request.body()));
                hashedRequestPayload = EncodeUtil.hexEncode((byte[])signer.hash(body));
                headers.put("content-type", "application/json");
            } else {
                body = StringUtils.toBytes((String)Objects.requireNonNull(ModelUtil.toFormString((Map)ModelUtil.query((Map)CommonUtil.assertAsMap((Object)request.body())))));
                hashedRequestPayload = EncodeUtil.hexEncode((byte[])signer.hash(body));
                headers.put("content-type", "application/x-www-form-urlencoded");
            }
        }
        headers.put(signer.getContent(), hashedRequestPayload);
        if (!(configuration.credentialProvider() instanceof AnonymousCredentialProvider)) {
            ICredential credential = configuration.credentialProvider().getCredentials();
            String accessKeyId = credential.accessKeyId();
            String securityToken = credential.securityToken();
            if (!StringUtils.isEmpty((CharSequence)securityToken)) {
                headers.put("x-acs-accesskey-id", accessKeyId);
                headers.put("x-acs-security-token", securityToken);
            }
            String strToSign = V3SignatureComposer.composeStringToSign(method, query, headers, request.pathname(), hashedRequestPayload);
            strToSign = signer.getSignerName().algorithmName() + "\n" + EncodeUtil.hexEncode((byte[])signer.hash(StringUtils.toBytes((String)strToSign)));
            SignerParams params = SignerParams.create();
            params.setCredentials(credential);
            headers.put("Authorization", signer.getSignerName().algorithmName() + " Credential=" + accessKeyId + ",Signature=" + signer.signString(strToSign, params) + ",SignedHeaders=" + V3SignatureComposer.buildSignedHeaders(headers));
        }
        HttpHeaders httpHeaders = new HttpHeaders(headers);
        httpRequest = new HttpRequest(method, ModelUtil.composeUrl((String)configuration.endpoint(), (Map)query, (String)configuration.protocol(), (String)request.pathname()));
        httpRequest.setHeaders(httpHeaders);
        if (!CommonUtil.isUnset((Object)body)) {
            httpRequest.setBody(body);
        }
        return httpRequest;
    }
}

