/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.HmacSHA1Signer;
import com.aliyuncs.auth.KeyPairCredentials;
import com.aliyuncs.auth.SHA256withRSASigner;

public abstract class Signer {
    private static final Signer hmacSHA1Signer = new HmacSHA1Signer();
    private static final Signer sha256withRSASigner = new SHA256withRSASigner();

    public abstract String signString(String var1, AlibabaCloudCredentials var2);

    public abstract String signString(String var1, String var2);

    public abstract String getSignerName();

    public abstract String getSignerVersion();

    public abstract String getSignerType();

    public static Signer getSigner(AlibabaCloudCredentials credentials) {
        if (credentials instanceof KeyPairCredentials) {
            return sha256withRSASigner;
        }
        return hmacSHA1Signer;
    }
}

