/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.aliyun.mns.adapter;

import com.aliyun.mns.model.Message;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.spark.streaming.aliyun.mns.adapter.MNSAgentUtil;

public class CloudQueueAgent {
    private Object cloudQueue;
    private Class cloudQueueClz;
    private String endpoint;
    private String queueName;
    private Gson gson = new Gson();
    private URLClassLoader urlClassLoader;

    public CloudQueueAgent(Object cloudQueue, Class cloudQueueClz, String endpoint, String queueName, URLClassLoader classLoader) {
        this.cloudQueue = cloudQueue;
        this.cloudQueueClz = cloudQueueClz;
        this.endpoint = endpoint;
        this.queueName = queueName;
        this.urlClassLoader = classLoader;
    }

    public List<Message> batchPopMessage(int batchMsgSize, int pollingWaitSeconds, boolean retry) throws Exception {
        try {
            Method method = this.cloudQueueClz.getMethod("batchPopMessage", Integer.TYPE, Integer.TYPE);
            Object ret = method.invoke(this.cloudQueue, batchMsgSize, pollingWaitSeconds);
            return (List)this.gson.fromJson(this.gson.toJson(ret), new TypeToken<List<Message>>(){}.getType());
        }
        catch (Exception e) {
            if (retry) {
                Object mnsClient = MNSAgentUtil.updateMNSClient(e, this.urlClassLoader, this.endpoint);
                if (mnsClient != null) {
                    Class<?> mnsClientClz = this.urlClassLoader.loadClass("com.aliyun.mns.client.MNSClient");
                    Method method = mnsClientClz.getMethod("getQueueRef", String.class);
                    this.cloudQueue = method.invoke(mnsClient, this.queueName);
                    return this.batchPopMessage(batchMsgSize, pollingWaitSeconds, false);
                }
                throw e;
            }
            throw e;
        }
    }

    public List<Message> batchPopMessage(int batchMsgSize, int pollingWaitSeconds) throws Exception {
        return this.batchPopMessage(batchMsgSize, pollingWaitSeconds, true);
    }

    public void batchDeleteMessage(List<String> receiptsToDelete, boolean retry) throws Exception {
        try {
            Method method = this.cloudQueueClz.getMethod("batchDeleteMessage", List.class);
            method.invoke(this.cloudQueue, receiptsToDelete);
        }
        catch (Exception e) {
            if (retry) {
                Object mnsClient = MNSAgentUtil.updateMNSClient(e, this.urlClassLoader, this.endpoint);
                if (mnsClient != null) {
                    Class<?> mnsClientClz = this.urlClassLoader.loadClass("com.aliyun.mns.client.MNSClient");
                    Method method = mnsClientClz.getMethod("getQueueRef", String.class);
                    this.cloudQueue = method.invoke(mnsClient, this.queueName);
                    this.batchDeleteMessage(receiptsToDelete, false);
                }
                throw e;
            }
            throw e;
        }
    }

    public void batchDeleteMessage(List<String> receiptsToDelete) throws Exception {
        this.batchDeleteMessage(receiptsToDelete, true);
    }
}

