/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.aliyun.mns.adapter;

import com.aliyun.ms.MetaClient;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.streaming.aliyun.mns.adapter.MNSClientAgent;
import org.apache.spark.streaming.aliyun.mns.adapter.ResourceLoader;

public class MNSAgentUtil {
    private static final Log LOG = LogFactory.getLog(MNSAgentUtil.class);

    public static MNSClientAgent getMNSClientAgent(String accessKeyId, String accessKeySecret, String endpoint, boolean runLocal) throws Exception {
        Configuration conf = new Configuration();
        if (accessKeyId == null || accessKeySecret == null) {
            String stsAccessKeyId = MetaClient.getRoleAccessKeyId();
            String stsAccessKeySecret = MetaClient.getRoleAccessKeySecret();
            String securityToken = MetaClient.getRoleSecurityToken();
            return MNSAgentUtil.getMNSClientAgent(stsAccessKeyId, stsAccessKeySecret, securityToken, endpoint, conf, runLocal);
        }
        return MNSAgentUtil.getMNSClientAgent(accessKeyId, accessKeySecret, endpoint, conf, runLocal);
    }

    private static MNSClientAgent getMNSClientAgent(String accessKeyId, String accessKeySecret, String endpoint, Configuration conf, boolean runLocal) throws Exception {
        URLClassLoader classLoader = ResourceLoader.getInstance().getUrlClassLoader(conf, runLocal);
        Class<?> cloudAccountClz = classLoader.loadClass("com.aliyun.mns.client.CloudAccount");
        Class<?> mnsClientClz = classLoader.loadClass("com.aliyun.mns.client.MNSClient");
        Constructor<?> cons = cloudAccountClz.getConstructor(String.class, String.class, String.class);
        Object cloudAccount = cons.newInstance(accessKeyId, accessKeySecret, endpoint);
        Method method = cloudAccountClz.getMethod("getMNSClient", new Class[0]);
        Object mnsClient = method.invoke(cloudAccount, new Object[0]);
        return new MNSClientAgent(mnsClient, mnsClientClz, endpoint, classLoader);
    }

    private static MNSClientAgent getMNSClientAgent(String accessKeyId, String accessKeySecret, String securityToken, String endpoint, Configuration conf, boolean runLocal) throws Exception {
        URLClassLoader classLoader = ResourceLoader.getInstance().getUrlClassLoader(conf, runLocal);
        Class<?> cloudAccountClz = classLoader.loadClass("com.aliyun.mns.client.CloudAccount");
        Class<?> mnsClientClz = classLoader.loadClass("com.aliyun.mns.client.MNSClient");
        Constructor<?> cons = cloudAccountClz.getConstructor(String.class, String.class, String.class, String.class);
        Object cloudAccount = cons.newInstance(accessKeyId, accessKeySecret, endpoint, securityToken);
        Method method = cloudAccountClz.getMethod("getMNSClient", new Class[0]);
        Object mnsClient = method.invoke(cloudAccount, new Object[0]);
        return new MNSClientAgent(mnsClient, mnsClientClz, endpoint, classLoader);
    }

    public static Object updateMNSClient(Exception e, URLClassLoader classLoader, String endpoint) throws Exception {
        Throwable t;
        if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()).getMessage().contains("The AccessKey Id you provided is not exist.")) {
            LOG.warn((Object)(t.getMessage() + ". Get AK information from MetaService and try again."));
            String accessKeyId = MetaClient.getRoleAccessKeyId();
            String accessKeySecret = MetaClient.getRoleAccessKeySecret();
            String securityToken = MetaClient.getRoleSecurityToken();
            try {
                Class<?> cloudAccountClz = classLoader.loadClass("com.aliyun.mns.client.CloudAccount");
                Class<?> mnsClientClz = classLoader.loadClass("com.aliyun.mns.client.MNSClient");
                Constructor<?> cons = cloudAccountClz.getConstructor(String.class, String.class, String.class, String.class);
                Object cloudAccount = cons.newInstance(accessKeyId, accessKeySecret, endpoint, securityToken);
                Method method = cloudAccountClz.getMethod("getMNSClient", new Class[0]);
                Object mnsClient = method.invoke(cloudAccount, new Object[0]);
                MNSClientAgent mnsClientAgent = new MNSClientAgent(mnsClient, mnsClientClz, endpoint, classLoader);
                try {
                    mnsClientAgent.isOpen();
                    return mnsClient;
                }
                catch (Exception e1) {
                    LOG.warn((Object)e1);
                    return null;
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
                return null;
            }
        }
        return null;
    }
}

