/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.aliyun.mns.adapter;

import com.google.gson.Gson;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.apache.spark.streaming.aliyun.mns.adapter.CloudQueueAgent;
import org.apache.spark.streaming.aliyun.mns.adapter.MNSAgentUtil;

public class MNSClientAgent {
    private static Gson gson = new Gson();
    private Class mnsClientClz;
    private Object mnsClient;
    private String endpoint;
    private URLClassLoader urlClassLoader;

    public MNSClientAgent(Object mnsClient, Class mnsClientClz, String endpoint, URLClassLoader classLoader) {
        this.mnsClientClz = mnsClientClz;
        this.mnsClient = mnsClient;
        this.endpoint = endpoint;
        this.urlClassLoader = classLoader;
    }

    public CloudQueueAgent getQueueRef(String queueName, boolean retry) throws Exception {
        try {
            Method method = this.mnsClientClz.getMethod("getQueueRef", String.class);
            Object cloudQueue = method.invoke(this.mnsClient, queueName);
            Class<?> cloudQueueClz = this.urlClassLoader.loadClass("com.aliyun.mns.client.CloudQueue");
            return new CloudQueueAgent(cloudQueue, cloudQueueClz, this.endpoint, queueName, this.urlClassLoader);
        }
        catch (Exception e) {
            if (retry) {
                Object mnsClient = MNSAgentUtil.updateMNSClient(e, this.urlClassLoader, this.endpoint);
                if (mnsClient != null) {
                    this.mnsClient = mnsClient;
                    return this.getQueueRef(queueName, false);
                }
                throw e;
            }
            throw e;
        }
    }

    public CloudQueueAgent getQueueRef(String queueName) throws Exception {
        return this.getQueueRef(queueName, true);
    }

    public boolean isOpen(boolean retry) throws Exception {
        try {
            Method method = this.mnsClientClz.getMethod("isOpen", new Class[0]);
            Object ret = method.invoke(this.mnsClient, new Object[0]);
            return (Boolean)gson.fromJson(gson.toJson(ret), Boolean.class);
        }
        catch (Exception e) {
            if (retry) {
                Object mnsClient = MNSAgentUtil.updateMNSClient(e, this.urlClassLoader, this.endpoint);
                if (mnsClient != null) {
                    this.mnsClient = mnsClient;
                    return this.isOpen(false);
                }
                throw e;
            }
            throw e;
        }
    }

    public boolean isOpen() throws Exception {
        return this.isOpen(true);
    }

    public synchronized void close(boolean retry) throws Exception {
        try {
            Method method = this.mnsClientClz.getMethod("close", new Class[0]);
            method.invoke(this.mnsClient, new Object[0]);
        }
        catch (Exception e) {
            if (retry) {
                Object mnsClient = MNSAgentUtil.updateMNSClient(e, this.urlClassLoader, this.endpoint);
                if (mnsClient != null) {
                    this.mnsClient = mnsClient;
                    this.close(false);
                }
                throw e;
            }
            throw e;
        }
    }

    public void close() throws Exception {
        this.close(true);
    }
}

