/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.aliyun.mns.adapter;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class ResourceLoader {
    private static final Log LOG = LogFactory.getLog(ResourceLoader.class);
    private URLClassLoader urlClassLoader = null;

    private ResourceLoader() {
    }

    public static ResourceLoader getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static List<URL> geClassLoaderURLs(Configuration conf, boolean runLocal) throws Exception {
        String dependPath = conf.get("fs.oss.sdk.dependency.path");
        String[] sdkDeps = null;
        if ((dependPath == null || dependPath.isEmpty()) && !runLocal) {
            throw new RuntimeException("Job dose not run locally, set \"fs.oss.sdk.dependency.path\" first please.");
        }
        if (dependPath == null || dependPath.isEmpty()) {
            LOG.info((Object)"\"mapreduce.job.run-local\" set true.");
        } else {
            sdkDeps = dependPath.split(",");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (sdkDeps != null) {
            for (String dep : sdkDeps) {
                urls.add(new URL("file://" + dep));
            }
        }
        if (runLocal) {
            String[] cp = SystemUtils.IS_OS_WINDOWS ? System.getProperty("java.class.path").split(";") : System.getProperty("java.class.path").split(":");
            for (String entity : cp) {
                urls.add(new URL("file:" + entity));
            }
        }
        return urls;
    }

    public synchronized URLClassLoader getUrlClassLoader(Configuration conf, boolean runLocal) {
        if (this.urlClassLoader == null) {
            try {
                List<URL> urls = ResourceLoader.geClassLoaderURLs(conf, runLocal);
                this.urlClassLoader = new URLClassLoader(urls.toArray(new URL[0]), null);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not initialize MNS URLClassLoader, " + e.getMessage());
            }
        }
        return this.urlClassLoader;
    }

    private static class LazyHolder {
        private static final ResourceLoader INSTANCE = new ResourceLoader();

        private LazyHolder() {
        }
    }
}

