/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.FastLog;
import com.aliyun.openservices.log.common.FastLogGroupMeta;
import com.aliyun.openservices.log.common.FastLogTag;
import com.aliyun.openservices.log.util.VarintUtil;
import java.util.ArrayList;

public class FastLogGroup {
    private byte[] rawBytes;
    private int beginOffset;
    private int endOffset;
    private ArrayList<FastLog> logs;
    private ArrayList<FastLogTag> tags;
    private FastLogGroupMeta meta;
    private int categoryOffset;
    private int categoryMessageOffset = -1;
    private int categoryMessageEnd = -1;
    private int topicOffset;
    private int sourceOffset;
    private int machineUUIDOffset;
    private int metaOffset;
    private int metaMessageOffset = -1;
    private int metaMessageEnd = -1;
    private byte[] logGroupBytes = null;
    private byte[] logGroupBytesWithoutMeta = null;

    public FastLogGroup(byte[] rawBytes, int offset, int length) {
        this.rawBytes = rawBytes;
        this.beginOffset = offset;
        this.endOffset = offset + length;
        this.categoryOffset = -1;
        this.topicOffset = -1;
        this.sourceOffset = -1;
        this.machineUUIDOffset = -1;
        this.metaOffset = -1;
        this.logs = new ArrayList();
        this.tags = new ArrayList();
        if (!this.parse()) {
            this.logs.clear();
            this.tags.clear();
            this.categoryOffset = -1;
            this.categoryMessageOffset = -1;
            this.topicOffset = -1;
            this.sourceOffset = -1;
            this.machineUUIDOffset = -1;
            this.metaOffset = -1;
            this.metaMessageOffset = -1;
        }
    }

    private boolean parse() {
        int pos = this.beginOffset;
        while (pos < this.endOffset) {
            int[] value = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
            if (value[0] == 0) {
                return false;
            }
            int mode = value[1] & 7;
            int index = value[1] >> 3;
            if (mode == 0) {
                pos = value[2];
                if ((value = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset))[0] == 0) {
                    return false;
                }
                pos = value[2];
                continue;
            }
            if (mode == 1) {
                pos = value[2] + 8;
                continue;
            }
            if (mode == 2) {
                switch (index) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.categoryMessageOffset = pos;
                        this.categoryOffset = value[2];
                        break;
                    }
                    case 3: {
                        this.topicOffset = value[2];
                        break;
                    }
                    case 4: {
                        this.sourceOffset = value[2];
                        break;
                    }
                    case 5: {
                        this.machineUUIDOffset = value[2];
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        this.metaMessageOffset = pos;
                        this.metaOffset = value[2];
                        break;
                    }
                }
                pos = value[2];
                value = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
                if (value[0] == 0) {
                    return false;
                }
                pos = value[2] + value[1];
                if (index == 1) {
                    this.logs.add(new FastLog(this.rawBytes, value[2], value[1]));
                    continue;
                }
                if (index == 2) {
                    this.categoryMessageEnd = pos;
                    continue;
                }
                if (index == 6) {
                    this.tags.add(new FastLogTag(this.rawBytes, value[2], value[1]));
                    continue;
                }
                if (index != 7) continue;
                this.meta = new FastLogGroupMeta(this.rawBytes, value[2], value[1]);
                this.metaMessageEnd = pos;
                continue;
            }
            if (mode == 5) {
                pos = value[2] + 4;
                continue;
            }
            return false;
        }
        return pos == this.endOffset;
    }

    public byte[] getBytesWithoutMeta() {
        if (this.logGroupBytesWithoutMeta == null) {
            this.logGroupBytesWithoutMeta = this.excludeCategoryAndMeta();
        }
        return this.logGroupBytesWithoutMeta;
    }

    private byte[] excludeCategoryAndMeta() {
        byte[] logGroupBytes;
        int length = this.endOffset - this.beginOffset;
        if (this.categoryMessageOffset >= 0 && this.metaMessageOffset >= 0) {
            int s3;
            int s2;
            logGroupBytes = new byte[length -= this.metaMessageEnd - this.metaMessageOffset + (this.categoryMessageEnd - this.categoryMessageOffset)];
            int s1 = Math.min(this.metaMessageOffset, this.categoryMessageOffset);
            int s4 = Math.max(this.metaMessageEnd, this.categoryMessageEnd);
            if (this.metaMessageOffset < this.categoryMessageOffset) {
                s2 = this.metaMessageEnd;
                s3 = this.categoryMessageOffset;
            } else {
                s2 = this.categoryMessageEnd;
                s3 = this.metaMessageOffset;
            }
            System.arraycopy(this.rawBytes, this.beginOffset, logGroupBytes, 0, s1 - this.beginOffset);
            int len = s1 - this.beginOffset;
            System.arraycopy(this.rawBytes, s2, logGroupBytes, len, s3 - s2);
            System.arraycopy(this.rawBytes, s4, this.logGroupBytes, len += s3 - s2, this.endOffset - s4);
        } else if (this.categoryMessageOffset >= 0) {
            logGroupBytes = new byte[length -= this.categoryMessageEnd - this.categoryMessageOffset];
            int prefixSize = this.categoryMessageOffset - this.beginOffset;
            System.arraycopy(this.rawBytes, this.beginOffset, logGroupBytes, 0, prefixSize);
            System.arraycopy(this.rawBytes, this.categoryMessageEnd, logGroupBytes, prefixSize, this.endOffset - this.categoryMessageEnd);
        } else if (this.metaMessageOffset >= 0) {
            logGroupBytes = new byte[length -= this.metaMessageEnd - this.metaMessageOffset];
            int prefixSize = this.metaMessageOffset - this.beginOffset;
            System.arraycopy(this.rawBytes, this.beginOffset, logGroupBytes, 0, prefixSize);
            System.arraycopy(this.rawBytes, this.metaMessageEnd, logGroupBytes, prefixSize, this.endOffset - this.metaMessageEnd);
        } else {
            logGroupBytes = new byte[length];
            System.arraycopy(this.rawBytes, this.beginOffset, logGroupBytes, 0, length);
        }
        return logGroupBytes;
    }

    public byte[] getBytes() {
        if (this.logGroupBytes == null) {
            this.logGroupBytes = this.excludeCategory();
        }
        return this.logGroupBytes;
    }

    private byte[] excludeCategory() {
        byte[] logGroupBytes;
        int length = this.endOffset - this.beginOffset;
        if (this.categoryMessageOffset >= 0) {
            logGroupBytes = new byte[length -= this.categoryMessageEnd - this.categoryMessageOffset];
            int prefixSize = this.categoryMessageOffset - this.beginOffset;
            System.arraycopy(this.rawBytes, this.beginOffset, logGroupBytes, 0, prefixSize);
            System.arraycopy(this.rawBytes, this.categoryMessageEnd, logGroupBytes, prefixSize, this.endOffset - this.categoryMessageEnd);
        } else {
            logGroupBytes = new byte[length];
            System.arraycopy(this.rawBytes, this.beginOffset, logGroupBytes, 0, length);
        }
        return logGroupBytes;
    }

    public String getCategory() {
        return this.decodeString(this.categoryOffset);
    }

    public String getTopic() {
        return this.decodeString(this.topicOffset);
    }

    public String getSource() {
        return this.decodeString(this.sourceOffset);
    }

    public String getMachineUUID() {
        return this.decodeString(this.machineUUIDOffset);
    }

    private String decodeString(int offset) {
        if (offset < 0) {
            return null;
        }
        int[] value = VarintUtil.DecodeVarInt32(this.rawBytes, offset, this.endOffset);
        if (value[0] == 0) {
            return null;
        }
        return new String(this.rawBytes, value[2], value[1]);
    }

    public byte[] getCategoryBytes() {
        return this.cutBytes(this.categoryOffset);
    }

    public byte[] getTopicBytes() {
        return this.cutBytes(this.topicOffset);
    }

    public byte[] getSourceBytes() {
        return this.cutBytes(this.sourceOffset);
    }

    public byte[] getMachineUUIDBytes() {
        return this.cutBytes(this.machineUUIDOffset);
    }

    private byte[] cutBytes(int offset) {
        if (offset < 0) {
            return null;
        }
        int[] value = VarintUtil.DecodeVarInt32(this.rawBytes, offset, this.endOffset);
        if (value[0] == 0) {
            return null;
        }
        byte[] cutBytes = new byte[value[1]];
        System.arraycopy(this.rawBytes, value[2], cutBytes, 0, value[1]);
        return cutBytes;
    }

    public int getLogTagsCount() {
        return this.tags.size();
    }

    public FastLogTag getLogTags(int i) {
        if (i < this.tags.size()) {
            return this.tags.get(i);
        }
        return null;
    }

    public int getLogsCount() {
        return this.logs.size();
    }

    public FastLog getLogs(int i) {
        if (i < this.logs.size()) {
            return this.logs.get(i);
        }
        return null;
    }

    public FastLogGroupMeta getMeta() {
        return this.meta;
    }

    public boolean hasCategory() {
        return this.categoryOffset >= 0;
    }

    public boolean hasTopic() {
        return this.topicOffset >= 0;
    }

    public boolean hasSource() {
        return this.sourceOffset >= 0;
    }

    public boolean hasMachineUUID() {
        return this.machineUUIDOffset >= 0;
    }

    public boolean hasMeta() {
        return this.metaOffset >= 0;
    }
}

