/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.util.VarintUtil;

public class FastLogGroupMeta {
    private byte[] rawBytes;
    private int beginOffset;
    private int endOffset;
    private int clientIPOffset = -1;
    private int clientIPLength = -1;
    private String clientIP;
    private byte[] clientIPBytes;
    private int receiveTime;

    public FastLogGroupMeta(byte[] rawBytes, int offset, int length) {
        this.rawBytes = rawBytes;
        this.beginOffset = offset;
        this.endOffset = offset + length;
        if (!this.parse()) {
            this.clientIPOffset = -1;
            this.receiveTime = -1;
        }
    }

    private boolean parse() {
        int pos = this.beginOffset;
        while (pos < this.endOffset) {
            int[] value = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
            if (value[0] == 0) {
                return false;
            }
            pos = value[2];
            int mode = value[1] & 7;
            int index = value[1] >> 3;
            if (index == 1 && mode == 0) {
                value = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
                if (value[0] == 0) {
                    return false;
                }
                this.receiveTime = value[1];
                pos = value[2];
                continue;
            }
            if (mode == 2 && index == 2) {
                value = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
                if (value[0] == 0) {
                    return false;
                }
                this.clientIPOffset = value[2];
                this.clientIPLength = value[1];
                pos = value[2] + value[1];
                continue;
            }
            pos = this.skip(mode, value[2]);
            if (pos != -1) continue;
            return false;
        }
        return pos == this.endOffset;
    }

    private int skip(int mode, int nextOffset) {
        switch (mode) {
            case 0: {
                int[] value = VarintUtil.DecodeVarInt32(this.rawBytes, nextOffset, this.endOffset);
                if (value[0] == 0) {
                    return -1;
                }
                return value[2];
            }
            case 1: {
                return nextOffset + 8;
            }
            case 2: {
                int[] value = VarintUtil.DecodeVarInt32(this.rawBytes, nextOffset, this.endOffset);
                if (value[0] == 0) {
                    return -1;
                }
                return value[2] + value[1];
            }
            case 5: {
                return nextOffset + 4;
            }
        }
        return -1;
    }

    public String getClientIP() {
        if (this.clientIP == null && this.hasClientIP()) {
            this.clientIP = new String(this.rawBytes, this.clientIPOffset, this.clientIPLength);
        }
        return this.clientIP;
    }

    public byte[] getClientIPBytes() {
        if (this.clientIPBytes == null && this.hasClientIP()) {
            this.clientIPBytes = new byte[this.clientIPLength];
            System.arraycopy(this.rawBytes, this.clientIPOffset, this.clientIPBytes, 0, this.clientIPLength);
        }
        return this.clientIPBytes;
    }

    public boolean hasClientIP() {
        return this.clientIPOffset >= 0;
    }

    public int getReceiveTime() {
        return this.receiveTime;
    }

    public boolean hasReceiveTime() {
        return this.receiveTime >= 0;
    }
}

