package com.aliyun.openservices.ons.api;

import com.aliyun.openservices.ons.api.batch.BatchConsumer;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;

import java.util.Properties;


/**
 * ONS客户端工厂类，用来创建客户端对象
 */
public class ONSFactory {
    private static ONSFactoryAPI onsFactory = null;

    static {
        try {
            // ons client 优先加载
            Class<?> factoryClass =
                    ONSFactory.class.getClassLoader().loadClass(
                            "com.aliyun.openservices.ons.api.impl.ONSFactoryNotifyAndMetaQImpl");
            onsFactory = (ONSFactoryAPI) factoryClass.newInstance();
        } catch (Throwable e) {
            try {
                Class<?> factoryClass =
                        ONSFactory.class.getClassLoader().loadClass(
                                "com.aliyun.openservices.ons.api.impl.ONSFactoryImpl");
                onsFactory = (ONSFactoryAPI) factoryClass.newInstance();
            } catch (Throwable e1) {
                e.printStackTrace();
                e1.printStackTrace();
            }
        }
    }


    /**
     * 创建Producer
     *
     * @param properties Producer的配置参数
     * @return {@code Producer} 实例
     */
    public static Producer createProducer(final Properties properties) {
        return onsFactory.createProducer(properties);
    }


    /**
     * 创建顺序Producer
     *
     * @param properties Producer的配置参数
     * @return {@code OrderProducer} 实例
     */
    public static OrderProducer createOrderProducer(final Properties properties) {
        return onsFactory.createOrderProducer(properties);
    }


    /**
     * 创建事务Producer
     *
     * @param properties Producer的配置参数
     * @return {@code TransactionProducer} 实例
     */
    public static TransactionProducer createTransactionProducer(final Properties properties,
                                                                final LocalTransactionChecker checker) {
        return onsFactory.createTransactionProducer(properties, checker);
    }


    /**
     * 创建Consumer
     *
     * @param properties Consumer的配置参数
     * @return {@code Consumer} 实例
     */
    public static Consumer createConsumer(final Properties properties) {
        return onsFactory.createConsumer(properties);
    }


    /**
     * 创建BatchConsumer
     *
     * @param properties BatchConsumer的配置参数
     * @return {@code BatchConsumer} 实例
     */
    public static BatchConsumer createBatchConsumer(final Properties properties) {
        return onsFactory.createBatchConsumer(properties);
    }


    /**
     * 创建顺序Consumer
     *
     * @param properties Consumer的配置参数
     * @return {@code OrderConsumer} 实例
     */
    public static OrderConsumer createOrderedConsumer(final Properties properties) {
        return onsFactory.createOrderedConsumer(properties);
    }
}
