package com.aliyun.openservices.ons.api.batch;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.List;

/**
 * 批量消息监听器，BatchConsumer注册消息监听器来批量地消费消息
 */
public interface BatchMessageListener {
    /**
     * 批量消费消息接口，由应用来实现<br>
     *
     * @param messages
     *         一批消息
     * @param context
     *         消费上下文
     *
     * @return 消费结果，如果应用抛出异常或者返回Null等价于返回Action.ReconsumeLater
     */
    Action consume(final List<Message> messages, final ConsumeContext context);
}
