/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractLambdaWrapper<T, This extends AbstractLambdaWrapper<T, This>>
extends AbstractWrapper<T, SFunction<T, ?>, This> {
    private Map<String, String> columnMap = null;
    private boolean initColumnMap = false;

    @Override
    protected void initEntityClass() {
        super.initEntityClass();
        if (this.entityClass != null) {
            this.columnMap = LambdaUtils.getColumnMap(this.entityClass.getName());
            this.initColumnMap = true;
        }
    }

    @Override
    protected String columnToString(SFunction<T, ?> column) {
        return this.getColumn(LambdaUtils.resolve(column));
    }

    private String getColumn(SerializedLambda lambda) {
        String fieldName = StringUtils.resolveFieldName(lambda.getImplMethodName());
        if (!this.initColumnMap || !this.columnMap.containsKey(fieldName)) {
            String entityClassName = lambda.getImplClassName();
            this.columnMap = LambdaUtils.getColumnMap(entityClassName);
            Assert.notEmpty(this.columnMap, "cannot find column's cache for %s, so you cannot used %s!", entityClassName, ((AbstractLambdaWrapper)this.typedThis).getClass());
            this.initColumnMap = true;
        }
        return Optional.ofNullable(this.columnMap.get(fieldName)).orElseThrow(() -> ExceptionUtils.mpe("your property named %s cannot find the corresponding database column name!", fieldName));
    }
}

