/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.common.runner;

import com.codingapi.txlcn.common.runner.TxLcnInitializer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;

public class TxLcnApplicationRunner
implements ApplicationRunner,
DisposableBean {
    private final ApplicationContext applicationContext;
    private List<TxLcnInitializer> initializers;

    @Autowired
    public TxLcnApplicationRunner(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void run(ApplicationArguments args) throws Exception {
        Map runnerMap = this.applicationContext.getBeansOfType(TxLcnInitializer.class);
        this.initializers = runnerMap.values().stream().sorted(Comparator.comparing(TxLcnInitializer::order)).collect(Collectors.toList());
        for (TxLcnInitializer txLcnInitializer : this.initializers) {
            txLcnInitializer.init();
        }
    }

    public void destroy() throws Exception {
        for (TxLcnInitializer txLcnInitializer : this.initializers) {
            txLcnInitializer.destroy();
        }
    }
}

