/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.common.util.serializer;

import com.codingapi.txlcn.common.util.serializer.DateDelegate;
import com.codingapi.txlcn.common.util.serializer.TimestampDelegate;
import com.codingapi.txlcn.common.util.serializer.jdk.ListMultimapDelegate;
import com.codingapi.txlcn.common.util.serializer.jdk.MultimapDelegate;
import com.codingapi.txlcn.common.util.serializer.jdk.MultisetDelegate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import io.protostuff.Schema;
import io.protostuff.runtime.DefaultIdStrategy;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.RuntimeEnv;
import io.protostuff.runtime.RuntimeSchema;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class SchemaCache {
    private static final DefaultIdStrategy idStrategy = (DefaultIdStrategy)RuntimeEnv.ID_STRATEGY;
    private static final Delegate<Timestamp> TIMESTAMP_DELEGATE = new TimestampDelegate();
    private static final Delegate<Date> DATE_DELEGATE = new DateDelegate();
    private static final Delegate<ListMultimap> LISTMULTIMAP_DELEGATE = new ListMultimapDelegate();
    private static final Delegate<Multimap> MULTIMAP_DELEGATE = new MultimapDelegate();
    private static final Delegate<Multiset> MULTISET_DELEGATE = new MultisetDelegate();
    private Cache<Class<?>, Schema<?>> cache = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterWrite(1L, TimeUnit.HOURS).build();

    public void registerDelegate(Delegate<?> delegate) {
        if (delegate != null) {
            idStrategy.registerDelegate(delegate);
        }
    }

    public static SchemaCache getInstance() {
        return SchemaCacheHolder.cache;
    }

    private Schema<?> get(Class<?> cls, Cache<Class<?>, Schema<?>> cache) {
        try {
            return (Schema)cache.get(cls, () -> RuntimeSchema.createFrom((Class)cls, (IdStrategy)idStrategy));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Schema<?> get(Class<?> cls) {
        return this.get(cls, this.cache);
    }

    static {
        idStrategy.registerDelegate(TIMESTAMP_DELEGATE);
        idStrategy.registerDelegate(DATE_DELEGATE);
        idStrategy.registerDelegate(LISTMULTIMAP_DELEGATE);
        idStrategy.registerDelegate(MULTIMAP_DELEGATE);
        idStrategy.registerDelegate(MULTISET_DELEGATE);
    }

    private static class SchemaCacheHolder {
        private static SchemaCache cache = new SchemaCache();

        private SchemaCacheHolder() {
        }
    }
}

