/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protocjar;

import com.github.os72.protocjar.MavenUtil;
import com.github.os72.protocjar.PlatformDetector;
import com.github.os72.protocjar.ProtocVersion;
import com.github.os72.protocjar.URLSpec;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Protoc {
    static String[] sDdownloadPaths = new String[]{"com/google/protobuf/protoc/", "com/github/os72/protoc/"};
    static String[] sStdTypesProto2 = new String[]{"include/google/protobuf/descriptor.proto"};
    static String[] sStdTypesProto3 = new String[]{"include/google/protobuf/any.proto", "include/google/protobuf/api.proto", "include/google/protobuf/descriptor.proto", "include/google/protobuf/duration.proto", "include/google/protobuf/empty.proto", "include/google/protobuf/field_mask.proto", "include/google/protobuf/source_context.proto", "include/google/protobuf/struct.proto", "include/google/protobuf/timestamp.proto", "include/google/protobuf/type.proto", "include/google/protobuf/wrappers.proto"};
    static Map<String, String[]> sStdTypesMap = new HashMap<String, String[]>();

    public static void main(String[] args) {
        try {
            if (args.length > 0 && args[0].equals("-pp")) {
                PlatformDetector.main(args);
                System.out.println("Detected platform: " + Protoc.getPlatformVerbose());
                return;
            }
            int exitCode = Protoc.runProtoc(args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            Protoc.log(e);
            e.printStackTrace();
        }
    }

    public static int runProtoc(String[] args) throws IOException, InterruptedException {
        return Protoc.runProtoc(args, System.out, System.err);
    }

    public static int runProtoc(String[] args, OutputStream out, OutputStream err) throws IOException, InterruptedException {
        ProtocVersion protocVersion = ProtocVersion.PROTOC_VERSION;
        boolean includeStdTypes = false;
        for (String arg : args) {
            ProtocVersion v = Protoc.getVersion(arg);
            if (v != null) {
                protocVersion = v;
            }
            if (!arg.equals("--include_std_types")) continue;
            includeStdTypes = true;
        }
        try {
            File protocTemp = Protoc.extractProtoc(protocVersion, includeStdTypes, null);
            return Protoc.runProtoc(protocTemp.getAbsolutePath(), Arrays.asList(args), out, err);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            String homeDir = System.getProperty("user.home");
            File protocTemp = Protoc.extractProtoc(protocVersion, includeStdTypes, new File(homeDir));
            return Protoc.runProtoc(protocTemp.getAbsolutePath(), Arrays.asList(args), out, err);
        }
    }

    public static int runProtoc(String cmd, String[] args) throws IOException, InterruptedException {
        return Protoc.runProtoc(cmd, Arrays.asList(args));
    }

    public static int runProtoc(String cmd, List<String> argList) throws IOException, InterruptedException {
        return Protoc.runProtoc(cmd, argList, System.out, System.err);
    }

    public static int runProtoc(String cmd, List<String> argList, OutputStream out, OutputStream err) throws IOException, InterruptedException {
        ProtocVersion protocVersion = ProtocVersion.PROTOC_VERSION;
        String javaShadedOutDir = null;
        ArrayList<String> protocCmd = new ArrayList<String>();
        protocCmd.add(cmd);
        for (String arg : argList) {
            if (arg.startsWith("--java_shaded_out=")) {
                javaShadedOutDir = arg.split("--java_shaded_out=")[1];
                protocCmd.add("--java_out=" + javaShadedOutDir);
                continue;
            }
            if (arg.equals("--include_std_types")) {
                File stdTypeDir = new File(new File(cmd).getParentFile().getParentFile(), "include");
                protocCmd.add("-I" + stdTypeDir.getAbsolutePath());
                continue;
            }
            ProtocVersion v = Protoc.getVersion(arg);
            if (v != null) {
                protocVersion = v;
                continue;
            }
            protocCmd.add(arg);
        }
        Process protoc = null;
        int numTries = 1;
        while (protoc == null) {
            try {
                Protoc.log("executing: " + protocCmd);
                ProcessBuilder pb = new ProcessBuilder(protocCmd);
                protoc = pb.start();
            }
            catch (IOException ioe) {
                if (numTries++ >= 3) {
                    throw ioe;
                }
                Protoc.log("caught exception, retrying: " + ioe);
                Thread.sleep(1000L);
            }
        }
        new Thread(new StreamCopier(protoc.getInputStream(), out)).start();
        new Thread(new StreamCopier(protoc.getErrorStream(), err)).start();
        int exitCode = protoc.waitFor();
        if (javaShadedOutDir != null) {
            Protoc.log("shading (version " + protocVersion + "): " + javaShadedOutDir);
            Protoc.doShading(new File(javaShadedOutDir), protocVersion.mVersion);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doShading(File dir, String version) throws IOException {
        if (dir.listFiles() == null) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Protoc.doShading(file, version);
                continue;
            }
            if (!file.getName().endsWith(".java")) continue;
            File tmpFile = null;
            PrintWriter pw = null;
            BufferedReader br = null;
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                String line;
                version = version.length() <= 5 ? version.replace(".", "") : "_" + version.replace(".", "_");
                tmpFile = File.createTempFile(file.getName(), null);
                pw = new PrintWriter(tmpFile);
                br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    pw.println(line.replace("com.google.protobuf", "com.github.os72.protobuf" + version));
                }
                pw.close();
                br.close();
                if (!file.delete()) {
                    Protoc.log("Failed to delete: " + file.getName());
                }
                is = new FileInputStream(tmpFile);
                os = new FileOutputStream(file);
                Protoc.streamCopy(is, os);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
                if (pw != null) {
                    try {
                        pw.close();
                    }
                    catch (Exception exception) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
    }

    public static File extractProtoc(ProtocVersion protocVersion, boolean includeStdTypes) throws IOException {
        return Protoc.extractProtoc(protocVersion, includeStdTypes, null);
    }

    public static File extractProtoc(ProtocVersion protocVersion, boolean includeStdTypes, File dir) throws IOException {
        File protocTemp = Protoc.extractProtoc(protocVersion, dir);
        if (includeStdTypes) {
            Protoc.extractStdTypes(protocVersion, protocTemp.getParentFile().getParentFile());
        }
        return protocTemp;
    }

    public static File extractProtoc(ProtocVersion protocVersion, File dir) throws IOException {
        Protoc.log("protoc version: " + protocVersion + ", detected platform: " + Protoc.getPlatformVerbose());
        File tmpDir = File.createTempFile("protocjar", "", dir);
        tmpDir.delete();
        tmpDir.mkdirs();
        tmpDir.deleteOnExit();
        File binDir = new File(tmpDir, "bin");
        binDir.mkdirs();
        binDir.deleteOnExit();
        File exeFile = null;
        if (protocVersion.mArtifact == null) {
            String srcFilePath = "bin/" + protocVersion.mVersion + "/" + Protoc.getProtocExeName(protocVersion);
            try {
                File protocTemp = new File(binDir, "protoc.exe");
                Protoc.populateFile(srcFilePath, protocTemp);
                Protoc.log("embedded: " + srcFilePath);
                protocTemp.setExecutable(true);
                protocTemp.deleteOnExit();
                return protocTemp;
            }
            catch (FileNotFoundException fileNotFoundException) {
                exeFile = Protoc.findDownloadProtoc(protocVersion);
            }
        } else {
            String downloadPath = protocVersion.mGroup.replace(".", "/") + "/" + protocVersion.mArtifact + "/";
            exeFile = Protoc.downloadProtoc(protocVersion, downloadPath, true);
        }
        if (exeFile == null) {
            throw new FileNotFoundException("Unsupported platform: " + Protoc.getProtocExeName(protocVersion));
        }
        File protocTemp = new File(binDir, "protoc.exe");
        Protoc.populateFile(exeFile.getAbsolutePath(), protocTemp);
        protocTemp.setExecutable(true);
        protocTemp.deleteOnExit();
        return protocTemp;
    }

    public static File findDownloadProtoc(ProtocVersion protocVersion) throws IOException {
        File exeFile2;
        for (String downloadPath : sDdownloadPaths) {
            try {
                exeFile2 = Protoc.downloadProtoc(protocVersion, downloadPath, false);
                if (exeFile2 == null) continue;
                return exeFile2;
            }
            catch (IOException exeFile2) {
                // empty catch block
            }
        }
        for (String downloadPath : sDdownloadPaths) {
            try {
                exeFile2 = Protoc.downloadProtoc(protocVersion, downloadPath, true);
                if (exeFile2 == null) continue;
                return exeFile2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static File downloadProtoc(ProtocVersion protocVersion, String downloadPath, boolean trueDownload) throws IOException {
        if (protocVersion.mVersion.endsWith("-SNAPSHOT")) {
            return Protoc.downloadProtocSnapshot(protocVersion, downloadPath);
        }
        MavenUtil.MavenSettings settings = MavenUtil.getMavenSettings();
        File webcacheDir = Protoc.getWebcacheDir();
        String mdSubPath = "maven-metadata.xml";
        URLSpec mdUrl = MavenUtil.getReleaseDownloadUrl(downloadPath + mdSubPath, settings);
        File mdFile = new File(webcacheDir, downloadPath + mdSubPath);
        mdFile = Protoc.downloadFile(mdUrl, mdFile, 28800000L);
        try {
            String lastBuildVersion = MavenUtil.parseLastReleaseBuild(mdFile, protocVersion);
            if (lastBuildVersion != null) {
                protocVersion = new ProtocVersion(protocVersion.mGroup, protocVersion.mArtifact, lastBuildVersion);
            }
        }
        catch (IOException lastBuildVersion) {
            // empty catch block
        }
        String exeSubPath = protocVersion.mVersion + "/" + Protoc.getProtocExeName(protocVersion);
        URLSpec exeUrl = MavenUtil.getReleaseDownloadUrl(downloadPath + exeSubPath, settings);
        File exeFile = new File(webcacheDir, downloadPath + exeSubPath);
        if (trueDownload) {
            return Protoc.downloadFile(exeUrl, exeFile, 0L);
        }
        if (exeFile.exists()) {
            Protoc.log("cached: " + exeFile);
            return exeFile;
        }
        return null;
    }

    public static File downloadProtocSnapshot(ProtocVersion protocVersion, String downloadPath) throws IOException {
        MavenUtil.MavenSettings settings = MavenUtil.getMavenSettings();
        File webcacheDir = Protoc.getWebcacheDir();
        String mdSubPath = protocVersion.mVersion + "/maven-metadata.xml";
        URLSpec mdUrl = MavenUtil.getSnapshotDownloadUrl(downloadPath + mdSubPath, settings);
        File mdFile = new File(webcacheDir, downloadPath + mdSubPath);
        String exeName = MavenUtil.parseSnapshotExeName(mdFile = Protoc.downloadFile(mdUrl, mdFile, 28800000L));
        if (exeName == null) {
            return null;
        }
        String exeSubPath = protocVersion.mVersion + "/" + exeName;
        URLSpec exeUrl = MavenUtil.getSnapshotDownloadUrl(downloadPath + exeSubPath, settings);
        File exeFile = new File(webcacheDir, downloadPath + exeSubPath);
        return Protoc.downloadFile(exeUrl, exeFile, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(URLSpec srcUrl, File destFile, long cacheTime) throws IOException {
        if (destFile.exists() && (cacheTime <= 0L || System.currentTimeMillis() - destFile.lastModified() <= cacheTime)) {
            Protoc.log("cached: " + destFile);
            return destFile;
        }
        File tmpFile = File.createTempFile("protocjar", ".tmp");
        InputStream is = null;
        FileOutputStream os = null;
        try {
            Protoc.log("downloading: " + srcUrl);
            URLConnection con = srcUrl.openConnection();
            con.setRequestProperty("User-Agent", "Mozilla");
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            is = con.getInputStream();
            os = new FileOutputStream(tmpFile);
            Protoc.streamCopy(is, os);
            is.close();
            os.close();
            destFile.getParentFile().mkdirs();
            destFile.delete();
            tmpFile.renameTo(destFile);
            destFile.setLastModified(System.currentTimeMillis());
        }
        catch (IOException e) {
            tmpFile.delete();
            if (!destFile.exists()) {
                throw e;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        Protoc.log("saved: " + destFile);
        return destFile;
    }

    public static File extractStdTypes(ProtocVersion protocVersion, File tmpDir) throws IOException {
        String[] stdTypes;
        if (tmpDir == null) {
            tmpDir = File.createTempFile("protocjar", "");
            tmpDir.delete();
            tmpDir.mkdirs();
            tmpDir.deleteOnExit();
        }
        File tmpDirProtos = new File(tmpDir, "include/google/protobuf");
        tmpDirProtos.mkdirs();
        tmpDirProtos.getParentFile().getParentFile().deleteOnExit();
        tmpDirProtos.getParentFile().deleteOnExit();
        tmpDirProtos.deleteOnExit();
        String majorProtoVersion = String.valueOf(protocVersion.mVersion.charAt(0));
        String srcPathPrefix = String.format("proto%s/", majorProtoVersion);
        for (String srcFilePath : stdTypes = sStdTypesMap.get(majorProtoVersion)) {
            File tmpFile = new File(tmpDir, srcFilePath);
            Protoc.populateFile(srcPathPrefix + srcFilePath, tmpFile);
            tmpFile.deleteOnExit();
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File populateFile(String srcFilePath, File destFile) throws IOException {
        String resourcePath = "/" + srcFilePath;
        FileOutputStream os = null;
        InputStream is = Protoc.class.getResourceAsStream(resourcePath);
        if (is == null) {
            is = new FileInputStream(srcFilePath);
        }
        try {
            os = new FileOutputStream(destFile);
            Protoc.streamCopy(is, os);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return destFile;
    }

    public static void streamCopy(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) > 0) {
            out.write(buf, 0, read);
        }
    }

    static File getWebcacheDir() throws IOException {
        File tmpFile = File.createTempFile("protocjar", ".tmp");
        File cacheDir = new File(tmpFile.getParentFile(), "protocjar.webcache");
        cacheDir.mkdirs();
        tmpFile.delete();
        return cacheDir;
    }

    static String getProtocExeName(ProtocVersion protocVersion) {
        return "protoc-" + protocVersion.mVersion + "-" + Protoc.getPlatformClassifier() + ".exe";
    }

    static String getPlatformVerbose() {
        return Protoc.getPlatformClassifier() + " (" + System.getProperty("os.name").toLowerCase() + "/" + System.getProperty("os.arch").toLowerCase() + ")";
    }

    static String getPlatformClassifier() {
        Properties detectorProps = new Properties();
        new PlatformDetector().detect(detectorProps, null);
        return detectorProps.getProperty("os.detected.classifier");
    }

    static ProtocVersion getVersion(String spec) {
        return ProtocVersion.getVersion(spec);
    }

    static void log(Object msg) {
        System.out.println("protoc-jar: " + msg);
    }

    static {
        sStdTypesMap.put("2", sStdTypesProto2);
        sStdTypesMap.put("3", sStdTypesProto3);
    }

    static class StreamCopier
    implements Runnable {
        private InputStream mIn;
        private OutputStream mOut;

        public StreamCopier(InputStream in, OutputStream out) {
            this.mIn = in;
            this.mOut = out;
        }

        public void run() {
            try {
                Protoc.streamCopy(this.mIn, this.mOut);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

