/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.LinkedHashMap;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;

public class JsonMapExpression
extends Expression {
    protected Map<String, Expression> map;
    public Expression[] array;

    public JsonMapExpression(Map<String, Expression> map, GrammarToken token) {
        super(token);
        this.map = map;
        this.array = map.values().toArray(new Expression[0]);
    }

    @Override
    public Object evaluate(Context ctx) {
        if (this.map.size() == 0) {
            return new LinkedHashMap();
        }
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(this.map.size());
        for (Map.Entry<String, Expression> entry : this.map.entrySet()) {
            values.put(entry.getKey(), entry.getValue().evaluate(ctx));
        }
        return values;
    }
}

