/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.http;

import com.jeesuite.common.crypt.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestEntity {
    private static final String DEFAULT_CHARSET = "utf-8";
    private String charset = "utf-8";
    private int connectTimeout = 5000;
    private int readTimeout = 10000;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> textParams = new HashMap<String, String>();
    private Map<String, FileItem> fileParams = new HashMap<String, FileItem>();
    private BasicAuthParams basicAuth;

    private HttpRequestEntity() {
    }

    public static HttpRequestEntity create() {
        return new HttpRequestEntity();
    }

    public String getCharset() {
        return this.charset;
    }

    public HttpRequestEntity charset(String charset) {
        this.charset = charset;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HttpRequestEntity connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HttpRequestEntity readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpRequestEntity headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getTextParams() {
        return this.textParams;
    }

    public HttpRequestEntity textParams(Map<String, String> textParams) {
        this.textParams = textParams;
        return this;
    }

    public Map<String, FileItem> getFileParams() {
        return this.fileParams;
    }

    public HttpRequestEntity fileParams(Map<String, FileItem> fileParams) {
        this.fileParams = fileParams;
        return this;
    }

    public BasicAuthParams getBasicAuth() {
        return this.basicAuth;
    }

    public HttpRequestEntity basicAuth(String userName, String password) {
        this.basicAuth = new BasicAuthParams(userName, password);
        return this;
    }

    public HttpRequestEntity addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpRequestEntity addTextParam(String name, String value) {
        this.textParams.put(name, value);
        return this;
    }

    public HttpRequestEntity addFileParam(String name, FileItem value) {
        this.fileParams.put(name, value);
        return this;
    }

    public static class FileItem {
        private String fileName;
        private String mimeType;
        private byte[] content;
        private File file;

        public FileItem(File file) {
            this.file = file;
        }

        public FileItem(String filePath) {
            this(new File(filePath));
        }

        public FileItem(String fileName, byte[] content) {
            this.fileName = fileName;
            this.content = content;
        }

        public FileItem(String fileName, byte[] content, String mimeType) {
            this(fileName, content);
            this.mimeType = mimeType;
        }

        public String getFileName() {
            if (this.fileName == null && this.file != null && this.file.exists()) {
                this.fileName = this.file.getName();
            }
            return this.fileName;
        }

        public String getMimeType() throws IOException {
            if (this.mimeType == null) {
                this.mimeType = FileItem.getMimeType(this.getContent());
            }
            return this.mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getContent() throws IOException {
            if (this.content == null && this.file != null && this.file.exists()) {
                FileInputStream in = null;
                ByteArrayOutputStream out = null;
                try {
                    int ch;
                    in = new FileInputStream(this.file);
                    out = new ByteArrayOutputStream();
                    while ((ch = ((InputStream)in).read()) != -1) {
                        out.write(ch);
                    }
                    this.content = out.toByteArray();
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
            }
            return this.content;
        }

        public static String getMimeType(byte[] bytes) {
            String suffix = FileItem.getFileSuffix(bytes);
            String mimeType = "JPG".equals(suffix) ? "image/jpeg" : ("GIF".equals(suffix) ? "image/gif" : ("PNG".equals(suffix) ? "image/png" : ("BMP".equals(suffix) ? "image/bmp" : "application/octet-stream")));
            return mimeType;
        }

        public static String getFileSuffix(byte[] bytes) {
            if (bytes == null || bytes.length < 10) {
                return null;
            }
            if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
                return "GIF";
            }
            if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
                return "PNG";
            }
            if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
                return "JPG";
            }
            if (bytes[0] == 66 && bytes[1] == 77) {
                return "BMP";
            }
            return null;
        }
    }

    public static class BasicAuthParams {
        private String name;
        private String password;

        public BasicAuthParams(String name, String password) {
            this.name = name;
            this.password = password;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getEncodeBasicAuth() {
            String encoded = Base64.encodeToString((this.name + ":" + this.password).getBytes(StandardCharsets.UTF_8), false);
            return "Basic " + encoded;
        }
    }
}

