/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jeesuite.common.json.JsonMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class JsonUtils {
    private static JsonMapper jsonMapper = JsonMapper.getDefault();

    public static ObjectMapper getMapper() {
        return jsonMapper.getMapper();
    }

    public static String toJson(Object object) {
        return jsonMapper.toJson(object);
    }

    public static String toJsonIgnoreNullField(Object object) {
        return JsonMapper.nonNullMapper().toJson(object);
    }

    public static String toPrettyJson(Object object) {
        try {
            return JsonUtils.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String jsonString, Class<T> clazz) {
        return jsonMapper.toObject(jsonString, clazz);
    }

    public static <T> List<T> toList(String jsonString, Class<T> clazz) {
        return jsonMapper.toList(jsonString, clazz);
    }

    public static JsonNode getNode(String jsonString, String nodeName) {
        try {
            JsonNode node = jsonMapper.getMapper().readTree(jsonString);
            return nodeName == null ? node : node.get(nodeName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJsonNodeValue(String jsonString, String attrs) {
        return JsonUtils.getJsonNodeValue(JsonUtils.getNode(jsonString, null), attrs);
    }

    public static String getJsonNodeValue(JsonNode node, String attrs) {
        int index = attrs.indexOf(46);
        if (index == -1) {
            if (node != null && node.get(attrs) != null) {
                return node.get(attrs).asText();
            }
            return null;
        }
        String s1 = attrs.substring(0, index);
        String s2 = attrs.substring(index + 1);
        return JsonUtils.getJsonNodeValue(node.get(s1), s2);
    }

    public static void main(String[] args) {
        ArrayList<Date> list = new ArrayList<Date>();
        list.add(new Date());
        System.out.println(JsonUtils.toJson(list));
    }
}

