/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.packagescan;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalScanner {
    private static final String SUFFIX_CLASS = ".class";
    private final Logger log = LoggerFactory.getLogger(InternalScanner.class);
    private Map<String, Set<String>> jarContentCache = new HashMap<String, Set<String>>();
    private ClassLoader classloader;

    InternalScanner(ClassLoader cl) {
        this.classloader = cl;
    }

    Set<String> findInPackages(Test test, String ... roots) {
        HashSet<String> localClsssOrPkgs = new HashSet<String>();
        for (String pkg : roots) {
            localClsssOrPkgs.addAll(this.findInPackage(test, pkg));
        }
        return localClsssOrPkgs;
    }

    List<String> findInPackage(Test test, String packageName) {
        Enumeration<URL> urls;
        ArrayList<String> localClsssOrPkgs = new ArrayList<String>();
        packageName = packageName.replace('.', '/');
        try {
            urls = this.classloader.getResources(packageName);
            if (!urls.hasMoreElements()) {
                this.log.warn("Unable to find any resources for package '" + packageName + "'");
            }
        }
        catch (IOException ioe) {
            this.log.warn("Could not read package: " + packageName);
            return localClsssOrPkgs;
        }
        return this.findInPackageWithUrls(test, packageName, urls);
    }

    List<String> findInPackageWithUrls(Test test, String packageName, Enumeration<URL> urls) {
        ArrayList<String> localClsssOrPkgs = new ArrayList<String>();
        while (urls.hasMoreElements()) {
            try {
                URL url = urls.nextElement();
                String urlPath = url.getPath();
                if (urlPath.lastIndexOf(33) > 0) {
                    if ((urlPath = urlPath.substring(0, urlPath.lastIndexOf(33))).startsWith("/")) {
                        urlPath = "file:" + urlPath;
                    }
                } else if (!urlPath.startsWith("file:")) {
                    urlPath = "file:" + urlPath;
                }
                this.log.debug("Scanning for packages in [" + urlPath + "].");
                File file = null;
                try {
                    URL fileURL = new URL(urlPath);
                    if ("file".equals(fileURL.getProtocol().toLowerCase())) {
                        file = new File(fileURL.toURI());
                    } else {
                        this.log.info("Skipping non file classpath element [ " + urlPath + " ]");
                    }
                }
                catch (URISyntaxException e) {
                    file = new File(urlPath.substring("file:".length()));
                }
                if (file != null && file.isDirectory()) {
                    localClsssOrPkgs.addAll(this.loadImplementationsInDirectory(test, packageName, file));
                    continue;
                }
                if (file == null || !test.matchesJar(file.getName())) continue;
                localClsssOrPkgs.addAll(this.loadImplementationsInJar(test, file));
            }
            catch (IOException ioe) {
                this.log.error("could not read entries: " + ioe);
            }
        }
        return localClsssOrPkgs;
    }

    List<String> loadImplementationsInDirectory(Test test, String parent, File location) {
        this.log.debug("Scanning directory " + location.getAbsolutePath() + " parent: '" + parent + "'.");
        File[] files = location.listFiles();
        ArrayList<String> localClsssOrPkgs = new ArrayList<String>();
        for (File file : files) {
            String packageOrClass = parent == null || parent.length() == 0 ? file.getName() : parent + "/" + file.getName();
            if (file.isDirectory()) {
                localClsssOrPkgs.addAll(this.loadImplementationsInDirectory(test, packageOrClass, file));
                continue;
            }
            if ("".equals(parent) && file.getName().endsWith(".jar") && test.matchesJar(file.getName())) {
                localClsssOrPkgs.addAll(this.loadImplementationsInJar(test, file));
                continue;
            }
            String pkg = packageOrClass;
            if (!pkg.endsWith(SUFFIX_CLASS)) continue;
            localClsssOrPkgs.add(pkg);
        }
        return localClsssOrPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> loadImplementationsInJar(Test test, File file) {
        ArrayList<String> localClsssOrPkgs = new ArrayList<String>();
        Set<String> packages = this.jarContentCache.get(file.getPath());
        if (packages == null) {
            packages = new HashSet<String>();
            try {
                JarFile jarFile = new JarFile(file);
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.endsWith(SUFFIX_CLASS)) continue;
                    localClsssOrPkgs.add(name);
                }
            }
            catch (IOException ioe) {
                this.log.error("Could not search jar file '" + file + "' for classes matching criteria: " + test + " due to an IOException" + ioe);
                List<String> list = Collections.emptyList();
                return list;
            }
            finally {
                this.jarContentCache.put(file.getPath(), packages);
            }
        }
        return localClsssOrPkgs;
    }

    static interface Test {
        public boolean matchesPackage(String var1);

        public boolean matchesJar(String var1);
    }
}

