/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import com.jeesuite.common.crypt.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    private static final String CARTSET_UTF_8 = "UTF-8";
    private static final String MD5_NAME = "MD5";
    private static final char[] saltChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./".toCharArray();

    public static String md5(Object content) {
        String keys = null;
        if (content == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(MD5_NAME);
            byte[] bPass = String.valueOf(content).getBytes(CARTSET_UTF_8);
            md.update(bPass);
            keys = DigestUtils.bytesToHexString(md.digest());
        }
        catch (NoSuchAlgorithmException aex) {
            System.out.println(aex);
        }
        catch (UnsupportedEncodingException uex) {
            System.out.println(uex);
        }
        return keys.toLowerCase();
    }

    public static String md5WithSalt(Object content, String salt) {
        if (content == null) {
            return null;
        }
        return DigestUtils.md5(content.toString().concat(salt));
    }

    public static String md5Short(String orig) {
        if (orig == null) {
            return null;
        }
        String md5 = DigestUtils.md5(orig);
        int offset = 8;
        String sub = md5.substring(offset, offset + 8);
        long sub16 = Long.parseLong(sub, 16);
        sub16 &= 0x3FFFFFFFL;
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < 6; ++j) {
            long t = sub16 & 0x3DL;
            sb.append(saltChars[(int)t]);
            sub16 >>= 5;
        }
        return sb.toString();
    }

    public static String encodeBase64(String string) {
        try {
            return Base64.encodeToString(string.getBytes(CARTSET_UTF_8), false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeBase64(String string) {
        try {
            return new String(Base64.decodeFast(string.getBytes(CARTSET_UTF_8)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(DigestUtils.md5Short("3rg56yyyyyyyy"));
    }
}

