/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class IdCardFormatVerifyHelper {
    private static final int MAX_MAINLAND_AREACODE = 659004;
    private static final int MIN_MAINLAND_AREACODE = 110000;
    private static final int HONGKONG_AREACODE = 810000;
    private static final int TAIWAN_AREACODE = 710000;
    private static final int MACAO_AREACODE = 820000;
    private static final Pattern regexBirthdayInLeapYear = Pattern.compile("^((19[0-9]{2})|(200[0-9])|(201[0-5]))((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))$");
    private static final Pattern regexBirthdayInCommonYear = Pattern.compile("^((19[0-9]{2})|(200[0-9])|(201[0-5]))((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))$");
    private static final Pattern byteRegex = Pattern.compile("^([0-9]{17}[0-9Xx])|([0-9]{15})$");
    private static String[] ValCodeArr = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static String[] Wi = new String[]{"7", "9", "10", "5", "8", "4", "2", "1", "6", "3", "7", "9", "10", "5", "8", "4", "2"};

    public static final boolean verifyFormat(String idNumber) {
        if (StringUtils.isBlank((CharSequence)idNumber)) {
            return false;
        }
        if (!IdCardFormatVerifyHelper.checkIdNumberRegex(idNumber = idNumber.trim())) {
            return false;
        }
        if (!IdCardFormatVerifyHelper.checkIdNumberArea(idNumber.substring(0, 6))) {
            return false;
        }
        if (!IdCardFormatVerifyHelper.checkBirthday((idNumber = IdCardFormatVerifyHelper.convertFifteenToEighteen(idNumber)).substring(6, 14))) {
            return false;
        }
        return IdCardFormatVerifyHelper.checkIdNumberVerifyCode(idNumber);
    }

    private static boolean checkIdNumberRegex(String idNumber) {
        return byteRegex.matcher(idNumber).matches();
    }

    private static boolean checkIdNumberArea(String idNumberArea) {
        int areaCode = Integer.parseInt(idNumberArea);
        if (areaCode == 810000 || areaCode == 820000 || areaCode == 710000) {
            return true;
        }
        return areaCode <= 659004 && areaCode >= 110000;
    }

    private static String convertFifteenToEighteen(String idNumber) {
        if (15 != idNumber.length()) {
            return idNumber;
        }
        idNumber = idNumber.substring(0, 6) + "19" + idNumber.substring(6, 15);
        idNumber = idNumber + IdCardFormatVerifyHelper.getVerifyCode(idNumber);
        return idNumber;
    }

    private static String getVerifyCode(String idNumber) {
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += Integer.parseInt(String.valueOf(idNumber.charAt(i))) * Integer.parseInt(Wi[i]);
        }
        return ValCodeArr[sum % 11];
    }

    private static boolean checkBirthday(String idNumberBirthdayStr) {
        Integer year = null;
        try {
            year = Integer.valueOf(idNumberBirthdayStr.substring(0, 4));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == year) {
            return false;
        }
        if (IdCardFormatVerifyHelper.isLeapYear(year)) {
            return regexBirthdayInLeapYear.matcher(idNumberBirthdayStr).matches();
        }
        return regexBirthdayInCommonYear.matcher(idNumberBirthdayStr).matches();
    }

    private static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
    }

    private static boolean checkIdNumberVerifyCode(String idNumber) {
        return IdCardFormatVerifyHelper.getVerifyCode(idNumber).equalsIgnoreCase(idNumber.substring(17));
    }

    public static void main(String[] args) {
        System.out.println(IdCardFormatVerifyHelper.verifyFormat("433130198401163211"));
    }
}

