/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PathMatcher {
    private List<String> uris = new ArrayList<String>();
    private List<String> uriPrefixs = new ArrayList<String>();
    private List<Pattern> uriPatterns = new ArrayList<Pattern>();

    public PathMatcher(String prefix, String uriPatterns) {
        this(prefix, StringUtils.trimToEmpty((String)uriPatterns).split(";|,"));
    }

    public PathMatcher(String prefix, String[] uris) {
        for (String uri : uris) {
            if (StringUtils.isBlank((CharSequence)uri)) continue;
            uri = prefix + uri;
            if (uri.contains("*")) {
                if (uri.endsWith("*")) {
                    this.uriPrefixs.add(uri.replaceAll("\\*+", ""));
                    continue;
                }
                this.uriPatterns.add(Pattern.compile(uri));
                continue;
            }
            this.uris.add(uri);
        }
    }

    public boolean match(String uri) {
        boolean matched = this.uris.contains(uri);
        if (matched) {
            return matched;
        }
        for (String prefix : this.uriPrefixs) {
            matched = uri.startsWith(prefix);
            if (!matched) continue;
            return true;
        }
        for (Pattern pattern : this.uriPatterns) {
            matched = pattern.matcher(uri).matches();
            if (!matched) continue;
            return true;
        }
        return false;
    }
}

