/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;

public final class ResourceUtils {
    public static final String NULL_VALUE_PLACEHOLDER = "_NULL_PLACEHOLDER_";
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static boolean inited;
    private static boolean merged;
    private static final Properties allProperties;
    private static Method envHelperGetPropertiesMethod;
    private static Method envHelperGetAllPropertiesMethod;

    private static synchronized void load() {
        if (inited) {
            return;
        }
        try {
            Class<?> threadClazz = Class.forName("com.jeesuite.spring.helper.EnvironmentHelper");
            envHelperGetPropertiesMethod = threadClazz.getMethod("getProperty", String.class);
            envHelperGetAllPropertiesMethod = threadClazz.getMethod("getAllProperties", String.class);
        }
        catch (Exception threadClazz) {
            // empty catch block
        }
        merged = envHelperGetAllPropertiesMethod == null && envHelperGetPropertiesMethod == null;
        try {
            File file;
            String extPropertyDir = System.getProperty("ext.config.dir");
            if (StringUtils.isNotBlank((CharSequence)extPropertyDir) && (file = new File(extPropertyDir)).exists()) {
                ResourceUtils.loadPropertiesFromFile(file);
            }
            System.out.println("CLASSPATH: " + System.getProperty("java.class.path"));
            URL url = Thread.currentThread().getContextClassLoader().getResource("");
            System.setProperty("framework.website", "www.jeesuite.com");
            if (url == null) {
                url = ResourceUtils.class.getResource("");
            }
            if (url == null) {
                return;
            }
            if (url.getProtocol().equals("file")) {
                System.out.println("loadPropertiesFromFile,origin:" + url.getPath());
                File parent = new File(url.getPath());
                if (!parent.exists()) {
                    System.err.println("loadPropertiesFromFile_error,dir not found");
                } else {
                    ResourceUtils.loadPropertiesFromFile(parent);
                }
            } else if (url.getProtocol().equals("jar")) {
                ResourceUtils.loadPropertiesFromJarFile(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            inited = true;
        }
    }

    private static void loadPropertiesFromJarFile(URL url) throws UnsupportedEncodingException, IOException {
        System.out.println("loadPropertiesFromJarFile,origin:" + url.toString());
        String jarFilePath = url.getFile();
        if (jarFilePath.contains("war!")) {
            jarFilePath = StringUtils.splitByWholeSeparator((String)jarFilePath, (String)"war!")[0] + "war";
        } else if (jarFilePath.contains("jar!")) {
            jarFilePath = StringUtils.splitByWholeSeparator((String)jarFilePath, (String)"jar!")[0] + "jar";
        }
        jarFilePath = jarFilePath.substring("file:".length());
        jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
        System.out.println("loadPropertiesFromJarFile,real:" + jarFilePath);
        JarFile jarFile = new JarFile(jarFilePath);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".properties")) continue;
            InputStream inputStream = jarFile.getInputStream(jarFile.getJarEntry(entry.getName()));
            Properties properties = new Properties();
            properties.load(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            allProperties.putAll((Map<?, ?>)properties);
        }
        jarFile.close();
    }

    private static void loadPropertiesFromFile(File parent) throws FileNotFoundException, IOException {
        File[] files = parent.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ResourceUtils.loadPropertiesFromFile(file);
                continue;
            }
            String path = file.getPath();
            if (!path.endsWith("properties") || path.contains("i18n")) continue;
            Properties p = new Properties();
            p.load(new FileReader(file));
            allProperties.putAll((Map<?, ?>)p);
            System.out.println("load properties from file:" + path);
        }
    }

    private static synchronized void mergeWithEnvironment() {
        if (merged) {
            return;
        }
        Map envProperties = null;
        if (envHelperGetAllPropertiesMethod != null) {
            try {
                envProperties = (Map)envHelperGetAllPropertiesMethod.invoke(null, "");
                if (envProperties == null || envProperties.isEmpty()) {
                    return;
                }
                for (String key : envProperties.keySet()) {
                    allProperties.setProperty(key, envProperties.get(key).toString());
                }
                merged = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        Set<Map.Entry<Object, Object>> entrySet = allProperties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            Object value = null;
            try {
                value = envHelperGetPropertiesMethod.invoke(null, entry.getKey());
                if (value == null) continue;
                allProperties.setProperty(entry.getKey().toString(), value.toString());
            }
            catch (Exception e) {
                return;
            }
        }
        merged = true;
    }

    public static Properties getAllProperties() {
        return ResourceUtils.getAllProperties(null);
    }

    public static Properties getAllProperties(String prefix) {
        if (!inited) {
            ResourceUtils.load();
        }
        if (!merged) {
            ResourceUtils.mergeWithEnvironment();
        }
        Properties properties = new Properties();
        Set<Map.Entry<Object, Object>> entrySet = allProperties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (!StringUtils.isBlank((CharSequence)prefix) && !entry.getKey().toString().startsWith(prefix)) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    @Deprecated
    public static String get(String key, String ... defaultValue) {
        if (defaultValue != null && defaultValue.length > 0 && defaultValue[0] != null) {
            return ResourceUtils.getProperty(key, defaultValue[0]);
        }
        return ResourceUtils.getProperty(key);
    }

    public static String getProperty(String key) {
        return ResourceUtils.getProperty(key, null);
    }

    public static String getAndValidateProperty(String key) {
        String value = ResourceUtils.getProperty(key, null);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(String.format("Property for key:%s not exists", key));
        }
        return value;
    }

    public static String getProperty(String key, String defaultValue) {
        String value;
        if (!inited) {
            ResourceUtils.load();
        }
        if (!merged) {
            ResourceUtils.mergeWithEnvironment();
        }
        if (StringUtils.isNotBlank((CharSequence)(value = System.getProperty(key)))) {
            return value;
        }
        value = System.getenv(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        if (allProperties.containsKey(key)) {
            return allProperties.getProperty(key);
        }
        return defaultValue;
    }

    public static int getInt(String key) {
        return ResourceUtils.getInt(key, 0);
    }

    public static int getInt(String key, int defalutValue) {
        String v = ResourceUtils.getProperty(key);
        if (v != null) {
            return Integer.parseInt(v);
        }
        return defalutValue;
    }

    public static long getLong(String key) {
        return ResourceUtils.getLong(key, 0L);
    }

    public static long getLong(String key, long defalutValue) {
        String v = ResourceUtils.getProperty(key);
        if (v != null) {
            return Long.parseLong(v);
        }
        return defalutValue;
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(ResourceUtils.getProperty(key));
    }

    public static boolean getBoolean(String key, boolean defalutValue) {
        return ResourceUtils.containsProperty(key) ? Boolean.parseBoolean(ResourceUtils.getProperty(key)) : defalutValue;
    }

    public static synchronized void merge(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            Object value = null;
            try {
                value = envHelperGetPropertiesMethod.invoke(null, entry.getKey());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null) {
                value = entry.getValue();
            }
            if (value == null) continue;
            allProperties.setProperty(entry.getKey().toString(), value.toString());
        }
    }

    public static synchronized void add(String key, String value) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) {
            return;
        }
        ResourceUtils.addToProperties(key, value);
    }

    public static boolean containsProperty(String key) {
        return allProperties.containsKey(key);
    }

    private static String addToProperties(String key, String value) {
        if (!value.contains(PLACEHOLDER_PREFIX)) {
            allProperties.put(key, value);
            return value;
        }
        String[] segments = value.split("\\$\\{");
        StringBuilder finalValue = new StringBuilder();
        for (int i = 0; i < segments.length; ++i) {
            String seg = StringUtils.trimToNull((String)segments[i]);
            if (StringUtils.isBlank((CharSequence)seg)) continue;
            if (seg.contains(PLACEHOLDER_SUFFIX)) {
                String refValue;
                String refKey = seg.substring(0, seg.indexOf(PLACEHOLDER_SUFFIX)).trim();
                String withBraceString = null;
                if (seg.contains("{")) {
                    withBraceString = seg.substring(seg.indexOf(PLACEHOLDER_SUFFIX) + 1);
                }
                String defaultValue = null;
                if (refKey.contains(":")) {
                    String[] tmpArray = refKey.split(":");
                    refKey = tmpArray[0];
                    defaultValue = tmpArray[1];
                }
                if (StringUtils.isBlank((CharSequence)(refValue = ResourceUtils.getProperty(refKey)))) {
                    refValue = defaultValue;
                }
                finalValue.append(refValue);
                if (withBraceString != null) {
                    finalValue.append(withBraceString);
                    continue;
                }
                String[] segments2 = seg.split("\\}");
                if (segments2.length != 2) continue;
                finalValue.append(segments2[1]);
                continue;
            }
            finalValue.append(seg);
        }
        allProperties.put(key, finalValue.toString());
        return finalValue.toString();
    }

    static {
        allProperties = new Properties();
    }
}

