/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import com.jeesuite.common.JeesuiteBaseException;
import com.jeesuite.common.crypt.DES;
import com.jeesuite.common.util.DigestUtils;
import com.jeesuite.common.util.ResourceUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class TokenGenerator {
    private static final String LINE_THROUGH = "-";
    private static final int EXPIRE = 180000;
    private static final String DES_CRYPT_KEY = ResourceUtils.getProperty("des.crypt.key");

    public static String generate(String ... prefixs) {
        String str = StringUtils.replace((String)UUID.randomUUID().toString(), (String)LINE_THROUGH, (String)"");
        if (prefixs != null && prefixs.length > 0 && StringUtils.isNotBlank((CharSequence)prefixs[0])) {
            return prefixs[0].concat(str);
        }
        return str;
    }

    public static String generateWithSign() {
        Date date = new Date();
        String cryptKey = TokenGenerator.getCryptKey(date);
        String str = DigestUtils.md5Short(TokenGenerator.generate(new String[0])).concat(String.valueOf(date.getTime()));
        return DES.encrypt(cryptKey, str).toLowerCase();
    }

    public static void validate(String token, boolean validateExpire) {
        long timestamp = 0L;
        Date date = new Date();
        String cryptKey = TokenGenerator.getCryptKey(date);
        try {
            timestamp = Long.parseLong(DES.decrypt(cryptKey, token).substring(6));
        }
        catch (Exception e) {
            throw new JeesuiteBaseException(4005, "\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (validateExpire && date.getTime() - timestamp > 180000L) {
            throw new JeesuiteBaseException(4005, "token\u5df2\u8fc7\u671f");
        }
    }

    private static String getCryptKey(Date date) {
        if (DES_CRYPT_KEY != null && DES_CRYPT_KEY.length() == 8) {
            return DES_CRYPT_KEY;
        }
        SimpleDateFormat format = new SimpleDateFormat("ddMMMyy", Locale.ENGLISH);
        String key = format.format(date).toUpperCase();
        key = DigestUtils.md5(key).substring(0, 8);
        return key;
    }

    public static void main(String[] args) {
        String generateWithSign = TokenGenerator.generateWithSign();
        System.out.println(generateWithSign);
        TokenGenerator.validate(generateWithSign, true);
    }
}

