/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.sentinel.nacos.configuration;

import com.nepxion.banner.Description;
import com.nepxion.banner.LogoBanner;
import com.nepxion.banner.NepxionBanner;
import com.nepxion.discovery.plugin.strategy.sentinel.configuration.SentinelStrategyAutoConfiguration;
import com.nepxion.discovery.plugin.strategy.sentinel.loader.SentinelRuleLoader;
import com.nepxion.discovery.plugin.strategy.sentinel.nacos.loader.SentinelNacosRuleLoader;
import com.taobao.text.Color;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.application.strategy.sentinel.enabled"}, matchIfMissing=false)
@AutoConfigureAfter(value={SentinelStrategyAutoConfiguration.class})
public class SentinelStrategyNacosAutoConfiguration {
    @Bean
    public SentinelRuleLoader sentinelRuleLoader() {
        return new SentinelNacosRuleLoader();
    }

    static {
        LogoBanner logoBanner = new LogoBanner(SentinelStrategyNacosAutoConfiguration.class, "/com/nepxion/sentinel/resource/logo.txt", "Welcome to Nepxion", 8, 5, new Color[]{Color.red, Color.green, Color.cyan, Color.blue, Color.yellow, Color.magenta, Color.red, Color.green}, true);
        NepxionBanner.show((LogoBanner)logoBanner, (Description[])new Description[]{new Description("Protect:", "Sentinel", 0, 1), new Description("Config:", "Nacos", 0, 1), new Description("Github:", "https://github.com/Nepxion/Discovery", 0, 1)});
    }
}

