/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.sentinel.nacos.loader;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.datasource.nacos.NacosDataSource;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.nepxion.discovery.common.nacos.configuration.NacosAutoConfiguration;
import com.nepxion.discovery.plugin.strategy.sentinel.loader.SentinelDataSourceRuleLoader;
import java.util.List;
import java.util.Properties;
import org.springframework.core.env.Environment;

public class SentinelNacosRuleLoader
extends SentinelDataSourceRuleLoader {
    private Properties properties;

    public void initialize() {
        this.properties = NacosAutoConfiguration.createNacosProperties((Environment)this.applicationContext.getEnvironment(), (boolean)false);
    }

    public ReadableDataSource<String, List<FlowRule>> getFlowRuleDataSource() {
        return new NacosDataSource(this.properties, this.pluginAdapter.getGroup(), this.pluginAdapter.getServiceId() + "-" + "sentinel-flow", (Converter)this.sentinelFlowRuleParser);
    }

    public ReadableDataSource<String, List<DegradeRule>> getDegradeRuleDataSource() {
        return new NacosDataSource(this.properties, this.pluginAdapter.getGroup(), this.pluginAdapter.getServiceId() + "-" + "sentinel-degrade", (Converter)this.sentinelDegradeRuleParser);
    }

    public ReadableDataSource<String, List<AuthorityRule>> getAuthorityRuleDataSource() {
        return new NacosDataSource(this.properties, this.pluginAdapter.getGroup(), this.pluginAdapter.getServiceId() + "-" + "sentinel-authority", (Converter)this.sentinelAuthorityRuleParser);
    }

    public ReadableDataSource<String, List<SystemRule>> getSystemRuleDataSource() {
        return new NacosDataSource(this.properties, this.pluginAdapter.getGroup(), this.pluginAdapter.getServiceId() + "-" + "sentinel-system", (Converter)this.sentinelSystemRuleParser);
    }

    public ReadableDataSource<String, List<ParamFlowRule>> getParamFlowRuleDataSource() {
        return new NacosDataSource(this.properties, this.pluginAdapter.getGroup(), this.pluginAdapter.getServiceId() + "-" + "sentinel-param-flow", (Converter)this.sentinelParamFlowRuleParser);
    }

    public String getConfigType() {
        return "Nacos";
    }
}

