/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.gateway.filter;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.StrategyCustomizationEntity;
import com.nepxion.discovery.common.entity.StrategyHeaderEntity;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.gateway.context.GatewayStrategyContext;
import com.nepxion.discovery.plugin.strategy.gateway.filter.GatewayStrategyFilterResolver;
import com.nepxion.discovery.plugin.strategy.gateway.filter.GatewayStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.gateway.monitor.GatewayStrategyMonitor;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractGatewayStrategyRouteFilter
implements GatewayStrategyRouteFilter {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Autowired(required=false)
    private GatewayStrategyMonitor gatewayStrategyMonitor;
    @Value(value="${spring.application.strategy.gateway.header.priority:true}")
    protected Boolean gatewayHeaderPriority;
    @Value(value="${spring.application.strategy.gateway.original.header.ignored:true}")
    protected Boolean gatewayOriginalHeaderIgnored;
    @Value(value="${spring.application.strategy.gateway.route.filter.order:9000}")
    protected Integer filterOrder;

    public int getOrder() {
        return this.filterOrder;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String path;
        StrategyHeaderEntity strategyHeaderEntity;
        StrategyCustomizationEntity strategyCustomizationEntity;
        GatewayStrategyContext.getCurrentContext().setExchange(exchange);
        ServerHttpRequest.Builder requestBuilder = exchange.getRequest().mutate();
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyCustomizationEntity = ruleEntity.getStrategyCustomizationEntity()) != null && (strategyHeaderEntity = strategyCustomizationEntity.getStrategyHeaderEntity()) != null) {
            Map headerMap = strategyHeaderEntity.getHeaderMap();
            for (Map.Entry entry : headerMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                GatewayStrategyFilterResolver.setHeader(requestBuilder, key, value, this.gatewayHeaderPriority);
            }
        }
        String routeVersion = this.getRouteVersion();
        String routeRegion = this.getRouteRegion();
        String routeAddress = this.getRouteAddress();
        String routeVersionWeight = this.getRouteVersionWeight();
        String routeRegionWeight = this.getRouteRegionWeight();
        if (StringUtils.isNotEmpty((CharSequence)routeVersion)) {
            GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-version", routeVersion, this.gatewayHeaderPriority);
        } else {
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
        }
        if (StringUtils.isNotEmpty((CharSequence)routeRegion)) {
            GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-region", routeRegion, this.gatewayHeaderPriority);
        } else {
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
        }
        if (StringUtils.isNotEmpty((CharSequence)routeAddress)) {
            GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-address", routeAddress, this.gatewayHeaderPriority);
        } else {
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
        }
        if (StringUtils.isNotEmpty((CharSequence)routeVersionWeight)) {
            GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-version-weight", routeVersionWeight, this.gatewayHeaderPriority);
        } else {
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version-weight", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
        }
        if (StringUtils.isNotEmpty((CharSequence)routeRegionWeight)) {
            GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-region-weight", routeRegionWeight, this.gatewayHeaderPriority);
        } else {
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region-weight", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
        }
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-group", this.pluginAdapter.getGroup(), this.gatewayHeaderPriority);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-type", this.pluginAdapter.getServiceType(), false);
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-app-id", serviceAppId, false);
        }
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-id", this.pluginAdapter.getServiceId(), false);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort(), false);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-version", this.pluginAdapter.getVersion(), false);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-region", this.pluginAdapter.getRegion(), false);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-env", this.pluginAdapter.getEnvironment(), false);
        ServerHttpRequest newRequest = requestBuilder.build();
        ServerWebExchange newExchange = exchange.mutate().request(newRequest).build();
        ServerWebExchange extensionExchange = this.extendFilter(newExchange, chain);
        ServerWebExchange finalExchange = extensionExchange != null ? extensionExchange : newExchange;
        GatewayStrategyContext.getCurrentContext().setExchange(newExchange);
        if (this.gatewayStrategyMonitor != null) {
            this.gatewayStrategyMonitor.monitor(finalExchange);
        }
        if ((path = finalExchange.getRequest().getPath().toString()).contains("/inspector/inspect")) {
            GatewayStrategyFilterResolver.setHeader(requestBuilder, "endpoint-inspector-inspect", this.pluginAdapter.getPluginInfo(null), true);
        }
        return chain.filter(finalExchange);
    }

    protected ServerWebExchange extendFilter(ServerWebExchange exchange, GatewayFilterChain chain) {
        return null;
    }

    public PluginAdapter getPluginAdapter() {
        return this.pluginAdapter;
    }

    public StrategyContextHolder getStrategyContextHolder() {
        return this.strategyContextHolder;
    }
}

