/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.sentinel.parser;

import com.alibaba.csp.sentinel.adapter.servlet.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebCallbackManager;
import com.nepxion.discovery.plugin.strategy.service.sentinel.adapter.ServiceSentinelRequestOriginAdapter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ServiceSentinelRequestOriginParser
implements RequestOriginParser {
    @Value(value="${spring.application.strategy.service.sentinel.request.origin.key:n-d-service-id}")
    private String requestOriginKey;
    @Autowired(required=false)
    private ServiceSentinelRequestOriginAdapter serviceSentinelRequestOriginAdapter;

    public ServiceSentinelRequestOriginParser() {
        WebCallbackManager.setRequestOriginParser((RequestOriginParser)this);
    }

    public String parseOrigin(HttpServletRequest request) {
        if (this.serviceSentinelRequestOriginAdapter != null) {
            return this.serviceSentinelRequestOriginAdapter.parseOrigin(request);
        }
        String requestOriginValue = request.getHeader(this.requestOriginKey);
        return StringUtils.isNotEmpty((CharSequence)requestOriginValue) ? requestOriginValue : "unknown";
    }
}

