/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AbstractOptionallyIdentifiedRequest;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.MapUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class TokenRequest
extends AbstractOptionallyIdentifiedRequest {
    private final AuthorizationGrant authzGrant;
    private final Scope scope;
    private final Map<String, String> customParams;

    public TokenRequest(URI uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope) {
        this(uri, clientAuth, authzGrant, scope, null);
    }

    public TokenRequest(URI uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope, Map<String, String> customParams) {
        super(uri, clientAuth);
        if (clientAuth == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        this.authzGrant = authzGrant;
        this.scope = scope;
        this.customParams = MapUtils.isNotEmpty(customParams) ? customParams : Collections.emptyMap();
    }

    public TokenRequest(URI uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant) {
        this(uri, clientAuth, authzGrant, null);
    }

    public TokenRequest(URI uri, ClientID clientID, AuthorizationGrant authzGrant, Scope scope) {
        this(uri, clientID, authzGrant, scope, null);
    }

    public TokenRequest(URI uri, ClientID clientID, AuthorizationGrant authzGrant, Scope scope, Map<String, String> customParams) {
        super(uri, clientID);
        if (authzGrant.getType().requiresClientAuthentication()) {
            throw new IllegalArgumentException("The \"" + authzGrant.getType() + "\" grant type requires client authentication");
        }
        if (authzGrant.getType().requiresClientID() && clientID == null) {
            throw new IllegalArgumentException("The \"" + authzGrant.getType() + "\" grant type requires a \"client_id\" parameter");
        }
        this.authzGrant = authzGrant;
        this.scope = scope;
        this.customParams = MapUtils.isNotEmpty(customParams) ? customParams : Collections.emptyMap();
    }

    public TokenRequest(URI uri, ClientID clientID, AuthorizationGrant authzGrant) {
        this(uri, clientID, authzGrant, null);
    }

    public TokenRequest(URI uri, AuthorizationGrant authzGrant, Scope scope) {
        this(uri, (ClientID)null, authzGrant, scope);
    }

    public TokenRequest(URI uri, AuthorizationGrant authzGrant) {
        this(uri, (ClientID)null, authzGrant, null);
    }

    public AuthorizationGrant getAuthorizationGrant() {
        return this.authzGrant;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParams;
    }

    public String getCustomParameter(String name) {
        return this.customParams.get(name);
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        URL url;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            url = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
        httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        Map<String, String> params = httpRequest.getQueryParameters();
        params.putAll(this.authzGrant.toParameters());
        if (this.scope != null && !this.scope.isEmpty()) {
            params.put("scope", this.scope.toString());
        }
        if (this.getClientID() != null) {
            params.put("client_id", this.getClientID().getValue());
        }
        if (!this.getCustomParameters().isEmpty()) {
            params.putAll(this.getCustomParameters());
        }
        httpRequest.setQuery(URLUtils.serializeParameters(params));
        return httpRequest;
    }

    public static TokenRequest parse(HTTPRequest httpRequest) throws ParseException {
        ClientAuthentication clientAuth;
        URI uri;
        try {
            uri = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        try {
            clientAuth = ClientAuthentication.parse(httpRequest);
        }
        catch (ParseException e) {
            throw new ParseException(e.getMessage(), OAuth2Error.INVALID_REQUEST.appendDescription(": " + e.getMessage()));
        }
        Map<String, String> params = httpRequest.getQueryParameters();
        if (clientAuth instanceof ClientSecretBasic && (StringUtils.isNotBlank(params.get("client_assertion")) || StringUtils.isNotBlank(params.get("client_assertion_type")))) {
            String msg = "Multiple conflicting client authentication methods found: Basic and JWT assertion";
            throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
        }
        AuthorizationGrant grant = AuthorizationGrant.parse(params);
        if (clientAuth == null && grant.getType().requiresClientAuthentication()) {
            String msg = "Missing client authentication";
            throw new ParseException(msg, OAuth2Error.INVALID_CLIENT.appendDescription(": " + msg));
        }
        ClientID clientID = null;
        if (clientAuth == null) {
            String clientIDString = params.get("client_id");
            if (clientIDString != null && !clientIDString.trim().isEmpty()) {
                clientID = new ClientID(clientIDString);
            }
            if (clientID == null && grant.getType().requiresClientID()) {
                String msg = "Missing required \"client_id\" parameter";
                throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
            }
        }
        String scopeValue = params.get("scope");
        Scope scope = null;
        if (scopeValue != null) {
            scope = Scope.parse(scopeValue);
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        for (Map.Entry<String, String> p : params.entrySet()) {
            if (p.getKey().equalsIgnoreCase("grant_type") || p.getKey().equalsIgnoreCase("client_id") || p.getKey().equalsIgnoreCase("client_secret") || p.getKey().equalsIgnoreCase("client_assertion_type") || p.getKey().equalsIgnoreCase("client_assertion") || p.getKey().equalsIgnoreCase("scope") || grant.getType().getRequestParameterNames().contains(p.getKey())) continue;
            customParams.put(p.getKey(), p.getValue());
        }
        if (clientAuth != null) {
            return new TokenRequest(uri, clientAuth, grant, scope, customParams);
        }
        return new TokenRequest(uri, clientID, grant, scope, customParams);
    }
}

