/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.thirdparty.org.bouncycastle.pqc.asn1;

import com.qcloud.cos.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import com.qcloud.cos.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import com.qcloud.cos.thirdparty.org.bouncycastle.asn1.ASN1Object;
import com.qcloud.cos.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import com.qcloud.cos.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import com.qcloud.cos.thirdparty.org.bouncycastle.asn1.DEROctetString;
import com.qcloud.cos.thirdparty.org.bouncycastle.asn1.DERSequence;
import com.qcloud.cos.thirdparty.org.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class XMSSPublicKey
extends ASN1Object {
    private final byte[] publicSeed;
    private final byte[] root;

    public XMSSPublicKey(byte[] byArray, byte[] byArray2) {
        this.publicSeed = Arrays.clone(byArray);
        this.root = Arrays.clone(byArray2);
    }

    private XMSSPublicKey(ASN1Sequence aSN1Sequence) {
        if (!ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue().equals(BigInteger.valueOf(0L))) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        this.publicSeed = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets());
        this.root = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets());
    }

    public static XMSSPublicKey getInstance(Object object) {
        if (object instanceof XMSSPublicKey) {
            return (XMSSPublicKey)object;
        }
        if (object != null) {
            return new XMSSPublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.publicSeed);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.root);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(0L));
        aSN1EncodableVector.add(new DEROctetString(this.publicSeed));
        aSN1EncodableVector.add(new DEROctetString(this.root));
        return new DERSequence(aSN1EncodableVector);
    }
}

