/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis;

import com.redislabs.provider.redis.ReadWriteConfig;
import com.redislabs.provider.redis.RedisConfig;
import com.redislabs.provider.redis.RedisContext$;
import com.redislabs.provider.redis.RedisNode;
import com.redislabs.provider.redis.util.PipelineUtils$;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class RedisContext$
implements Serializable {
    public static final RedisContext$ MODULE$;

    static {
        new RedisContext$();
    }

    public void setKVs(Iterator<Tuple2<String, String>> arr, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Predef$.MODULE$.refArrayOps((Object[])arr.map((Function1)new Serializable(redisConfig){
            public static final long serialVersionUID = 0L;
            private final RedisConfig redisConfig$2;

            public final Tuple2<RedisNode, Tuple2<String, String>> apply(Tuple2<String, String> kv) {
                return new Tuple2((Object)this.redisConfig$2.getHost((String)kv._1()), kv);
            }
            {
                this.redisConfig$2 = redisConfig$2;
            }
        }).toArray(ClassTag$.MODULE$.apply(Tuple2.class))).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RedisNode apply(Tuple2<RedisNode, Tuple2<String, String>> x$1) {
                return (RedisNode)x$1._1();
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String>[] apply(Tuple2<RedisNode, Tuple2<String, String>>[] a) {
                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])a).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(Tuple2<RedisNode, Tuple2<String, String>> p) {
                        return (Tuple2)p._2();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            }
        }).foreach((Function1)new Serializable(ttl, rwConf){
            public static final long serialVersionUID = 0L;
            public final int ttl$2;
            private final ReadWriteConfig rwConf$1;

            public final void apply(Tuple2<RedisNode, Tuple2<String, String>[]> x) {
                Jedis conn = ((RedisNode)x._1()).endpoint().connect();
                PipelineUtils$.MODULE$.foreachWithPipeline(conn, Predef$.MODULE$.refArrayOps((Object[])x._2()), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.setKVs.4 $outer;

                    public final void apply(Pipeline x0$1, Tuple2<String, String> x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                        if (tuple2 != null) {
                            Pipeline pipeline = (Pipeline)tuple2._1();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                BoxedUnit boxedUnit;
                                String k = (String)tuple22._1();
                                String v = (String)tuple22._2();
                                if (this.$outer.ttl$2 <= 0) {
                                    pipeline.set(k, v);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    pipeline.setex(k, this.$outer.ttl$2, v);
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.rwConf$1);
                conn.close();
            }
            {
                this.ttl$2 = ttl$2;
                this.rwConf$1 = rwConf$1;
            }
        });
    }

    public void setHash(String hashName, Iterator<Tuple2<String, String>> arr, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Jedis conn = redisConfig.connectionForKey(hashName);
        Pipeline pipeline = PipelineUtils$.MODULE$.foreachWithPipelineNoLastSync(conn, arr, new Serializable(hashName){
            public static final long serialVersionUID = 0L;
            private final String hashName$2;

            public final void apply(Pipeline x0$2, Tuple2<String, String> x1$2) {
                Tuple2 tuple2 = new Tuple2((Object)x0$2, x1$2);
                if (tuple2 != null) {
                    Pipeline pipeline = (Pipeline)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        String k = (String)tuple22._1();
                        String v = (String)tuple22._2();
                        pipeline.hset(this.hashName$2, k, v);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.hashName$2 = hashName$2;
            }
        }, rwConf);
        Object object = ttl > 0 ? pipeline.expire(hashName, ttl) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    public void setZset(String zsetName, Iterator<Tuple2<String, String>> arr, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Jedis conn = redisConfig.connectionForKey(zsetName);
        Pipeline pipeline = PipelineUtils$.MODULE$.foreachWithPipelineNoLastSync(conn, arr, new Serializable(zsetName){
            public static final long serialVersionUID = 0L;
            private final String zsetName$2;

            public final void apply(Pipeline x0$3, Tuple2<String, String> x1$3) {
                Tuple2 tuple2 = new Tuple2((Object)x0$3, x1$3);
                if (tuple2 != null) {
                    Pipeline pipeline = (Pipeline)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        String k = (String)tuple22._1();
                        String v = (String)tuple22._2();
                        pipeline.zadd(this.zsetName$2, new StringOps(Predef$.MODULE$.augmentString(v)).toDouble(), k);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.zsetName$2 = zsetName$2;
            }
        }, rwConf);
        Object object = ttl > 0 ? pipeline.expire(zsetName, ttl) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    public void setSet(String setName, Iterator<String> arr, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Jedis conn = redisConfig.connectionForKey(setName);
        Pipeline pipeline = PipelineUtils$.MODULE$.foreachWithPipelineNoLastSync(conn, arr, new Serializable(setName){
            public static final long serialVersionUID = 0L;
            private final String setName$2;

            public final void apply(Pipeline pipeline, String v) {
                pipeline.sadd(this.setName$2, new String[]{v});
            }
            {
                this.setName$2 = setName$2;
            }
        }, rwConf);
        Object object = ttl > 0 ? pipeline.expire(setName, ttl) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    public void setList(String listName, Iterator<String> arr, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Jedis conn = redisConfig.connectionForKey(listName);
        Pipeline pipeline = PipelineUtils$.MODULE$.foreachWithPipelineNoLastSync(conn, arr, new Serializable(listName){
            public static final long serialVersionUID = 0L;
            private final String listName$2;

            public final void apply(Pipeline pipeline, String v) {
                pipeline.rpush(this.listName$2, new String[]{v});
            }
            {
                this.listName$2 = listName$2;
            }
        }, rwConf);
        Object object = ttl > 0 ? pipeline.expire(listName, ttl) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    public void setFixedList(String key, int listSize, Iterator<String> arr, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Jedis conn = redisConfig.connectionForKey(key);
        Pipeline pipeline = PipelineUtils$.MODULE$.foreachWithPipelineNoLastSync(conn, arr, new Serializable(key){
            public static final long serialVersionUID = 0L;
            private final String key$1;

            public final void apply(Pipeline pipeline, String v) {
                pipeline.lpush(this.key$1, new String[]{v});
            }
            {
                this.key$1 = key$1;
            }
        }, rwConf);
        Object object = listSize > 0 ? pipeline.ltrim(key, 0L, (long)(listSize - 1)) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RedisContext$() {
        MODULE$ = this;
    }
}

