/*
 * Decompiled with CFR 0.152.
 */
package com.uber.h3core;

import com.uber.h3core.NativeMethods;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class H3CoreLoader {
    static final String ARCH_X64 = "x64";
    static final String ARCH_X86 = "x86";
    static final String ARCH_ARM64 = "arm64";
    private static volatile File libraryFile = null;

    H3CoreLoader() {
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    static void copyResource(String resourcePath, File newH3LibFile) throws IOException {
        newH3LibFile.setReadable(true);
        newH3LibFile.setWritable(true, true);
        newH3LibFile.setExecutable(true, true);
        try (InputStream resource = H3CoreLoader.class.getResourceAsStream(resourcePath);){
            if (resource == null) {
                throw new UnsatisfiedLinkError(String.format("No native resource found at %s", resourcePath));
            }
            try (FileOutputStream outFile = new FileOutputStream(newH3LibFile);){
                H3CoreLoader.copyStream(resource, outFile);
            }
        }
    }

    public static NativeMethods loadNatives() throws IOException {
        OperatingSystem os = H3CoreLoader.detectOs(System.getProperty("java.vendor"), System.getProperty("os.name"));
        String arch = H3CoreLoader.detectArch(System.getProperty("os.arch"));
        return H3CoreLoader.loadNatives(os, arch);
    }

    public static synchronized NativeMethods loadNatives(OperatingSystem os, String arch) throws IOException {
        if (libraryFile == null) {
            String dirName = String.format("%s-%s", os.getDirName(), arch);
            String libName = String.format("libh3-java%s", os.getSuffix());
            File newLibraryFile = File.createTempFile("libh3-java", os.getSuffix());
            newLibraryFile.deleteOnExit();
            H3CoreLoader.copyResource(String.format("/%s/%s", dirName, libName), newLibraryFile);
            libraryFile = newLibraryFile;
        }
        System.load(libraryFile.getCanonicalPath());
        return new NativeMethods();
    }

    public static NativeMethods loadSystemNatives() {
        System.loadLibrary("h3-java");
        return new NativeMethods();
    }

    static final OperatingSystem detectOs(String javaVendor, String osName) {
        if (javaVendor.toLowerCase().contains("android")) {
            return OperatingSystem.ANDROID;
        }
        String javaOs = osName.toLowerCase();
        if (javaOs.contains("mac")) {
            return OperatingSystem.DARWIN;
        }
        if (javaOs.contains("win")) {
            return OperatingSystem.WINDOWS;
        }
        return OperatingSystem.LINUX;
    }

    static final String detectArch(String osArch) {
        if (osArch.equals("amd64") || osArch.equals("x86_64")) {
            return ARCH_X64;
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("i786") || osArch.equals("i886")) {
            return ARCH_X86;
        }
        if (osArch.equals("aarch64")) {
            return ARCH_ARM64;
        }
        return osArch;
    }

    public static enum OperatingSystem {
        ANDROID(".so"),
        DARWIN(".dylib"),
        WINDOWS(".dll"),
        LINUX(".so");

        private final String suffix;

        private OperatingSystem(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getDirName() {
            return this.name().toLowerCase();
        }
    }
}

