/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.pool;

import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.net.params.BaseCallback;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.pool.ClientPoolFactory;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.IpUtil;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientPooled {
    protected static transient Logger logger = LoggerFactory.getLogger(ClientPooled.class);
    private static ConcurrentHashMap<String, GenericObjectPool<ClientPooled>> clientPoolMap;

    public abstract void init(String var1, int var2, Serializer var3, XxlRpcInvokerFactory var4) throws Exception;

    public abstract void close();

    public abstract boolean isValidate();

    public abstract void send(XxlRpcRequest var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static GenericObjectPool<ClientPooled> getPool(String address, Class<? extends ClientPooled> clientPoolImpl, Serializer serializer, XxlRpcInvokerFactory xxlRpcInvokerFactory) throws Exception {
        GenericObjectPool clientPool;
        if (clientPoolMap == null) {
            Class<ClientPooled> clazz = ClientPooled.class;
            // MONITORENTER : com.xxl.rpc.remoting.net.pool.ClientPooled.class
            if (clientPoolMap == null) {
                clientPoolMap = new ConcurrentHashMap();
                xxlRpcInvokerFactory.addStopCallBack(new BaseCallback(){

                    @Override
                    public void run() throws Exception {
                        if (clientPoolMap.size() > 0) {
                            for (String key : clientPoolMap.keySet()) {
                                GenericObjectPool clientPool = (GenericObjectPool)clientPoolMap.get(key);
                                clientPool.close();
                            }
                            clientPoolMap.clear();
                        }
                    }
                });
            }
            // MONITOREXIT : clazz
        }
        if ((clientPool = clientPoolMap.get(address)) != null) {
            return clientPool;
        }
        ConcurrentHashMap<String, GenericObjectPool<ClientPooled>> concurrentHashMap = clientPoolMap;
        // MONITORENTER : concurrentHashMap
        clientPool = clientPoolMap.get(address);
        if (clientPool != null) {
            // MONITOREXIT : concurrentHashMap
            return clientPool;
        }
        Object[] array = IpUtil.parseIpPort(address);
        String host = (String)array[0];
        int port = (Integer)array[1];
        clientPool = new GenericObjectPool((PooledObjectFactory)new ClientPoolFactory(clientPoolImpl, host, port, serializer, xxlRpcInvokerFactory));
        clientPool.setTestOnBorrow(true);
        clientPool.setMaxTotal(2);
        clientPoolMap.put(address, (GenericObjectPool<ClientPooled>)clientPool);
        // MONITOREXIT : concurrentHashMap
        return clientPool;
    }
}

