/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.mock.MyCloudEventData;
import io.cloudevents.rw.CloudEventDataMapper;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CloudEventUtilsTest {
    CloudEventUtilsTest() {
    }

    @Test
    void mapDataWithNullData() {
        AtomicInteger i = new AtomicInteger();
        CloudEventDataMapper mapper = data -> {
            i.incrementAndGet();
            return data;
        };
        CloudEvent cloudEvent = CloudEventBuilder.v1().withId("aaa").withSource(URI.create("localhost")).withType("bbb").build();
        Assertions.assertThat((Object)CloudEventUtils.mapData((CloudEvent)cloudEvent, (CloudEventDataMapper)mapper)).isNull();
        Assertions.assertThat((AtomicInteger)i).hasValue(0);
    }

    @Test
    void mapData() {
        AtomicInteger i = new AtomicInteger();
        CloudEventDataMapper mapper = data -> {
            i.incrementAndGet();
            return data;
        };
        MyCloudEventData data2 = new MyCloudEventData(10);
        CloudEvent cloudEvent = ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId("aaa").withSource(URI.create("localhost")).withType("bbb").withData((CloudEventData)data2)).build();
        Assertions.assertThat((Object)CloudEventUtils.mapData((CloudEvent)cloudEvent, (CloudEventDataMapper)mapper)).isEqualTo((Object)data2);
        Assertions.assertThat((AtomicInteger)i).hasValue(1);
    }
}

