/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.data;

import io.cloudevents.core.data.PojoCloudEventData;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PojoCloudEventDataTest {
    PojoCloudEventDataTest() {
    }

    @Test
    void testWrapAndMemoization() {
        PojoCloudEventData data = PojoCloudEventData.wrap((Object)10, i -> i.toString().getBytes());
        Assertions.assertThat((Integer)((Integer)data.getValue())).isEqualTo(10);
        byte[] firstConversion = data.toBytes();
        Assertions.assertThat((byte[])firstConversion).isEqualTo((Object)"10".getBytes());
        Assertions.assertThat((byte[])data.toBytes()).isSameAs((Object)firstConversion);
    }

    @Test
    void testAlreadySerializedValue() {
        byte[] serialized = "10".getBytes();
        PojoCloudEventData data = PojoCloudEventData.wrap((Object)10, v -> serialized);
        Assertions.assertThat((Integer)((Integer)data.getValue())).isEqualTo(10);
        Assertions.assertThat((byte[])data.toBytes()).isSameAs((Object)serialized);
    }
}

