/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.extensions;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.extensions.DistributedTracingExtension;
import io.cloudevents.core.provider.ExtensionProvider;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DistributedTracingExtensionTest {
    @Test
    public void writeExtension() {
        DistributedTracingExtension tracing = new DistributedTracingExtension();
        tracing.setTraceparent("parent");
        tracing.setTracestate("state");
        CloudEvent event = ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId("aaa").withSource(URI.create("http://localhost")).withType("example").withExtension((CloudEventExtension)tracing)).build();
        Assertions.assertThat((Object)event.getExtension("traceparent")).isEqualTo((Object)"parent");
        Assertions.assertThat((Object)event.getExtension("tracestate")).isEqualTo((Object)"state");
    }

    @Test
    public void parseExtension() {
        CloudEvent event = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId("aaa").withSource(URI.create("http://localhost")).withType("example").withExtension("traceparent", "parent")).withExtension("tracestate", "state")).build();
        DistributedTracingExtension tracing = (DistributedTracingExtension)ExtensionProvider.getInstance().parseExtension(DistributedTracingExtension.class, (CloudEventExtensions)event);
        Assertions.assertThat((Object)tracing).isNotNull();
        Assertions.assertThat((String)tracing.getTraceparent()).isEqualTo("parent");
        Assertions.assertThat((String)tracing.getTracestate()).isEqualTo("state");
    }
}

