/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.mock;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.types.Time;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class CSVFormat
implements EventFormat {
    public static final CSVFormat INSTANCE = new CSVFormat();

    public byte[] serialize(CloudEvent event) {
        return String.join((CharSequence)",", event.getSpecVersion().toString(), event.getId(), event.getType(), event.getSource().toString(), Objects.toString(event.getDataContentType()), Objects.toString(event.getDataSchema()), Objects.toString(event.getSubject()), event.getTime() != null ? Time.writeTime((OffsetDateTime)event.getTime()) : "null", event.getData() != null ? new String(Base64.getEncoder().encode(event.getData().toBytes()), StandardCharsets.UTF_8) : "null").getBytes();
    }

    public CloudEvent deserialize(byte[] bytes, CloudEventDataMapper mapper) {
        String[] splitted = new String(bytes, StandardCharsets.UTF_8).split(Pattern.quote(","));
        SpecVersion sv = SpecVersion.parse((String)splitted[0]);
        String id = splitted[1];
        String type = splitted[2];
        URI source = URI.create(splitted[3]);
        String datacontenttype = splitted[4].equals("null") ? null : splitted[4];
        URI dataschema = splitted[5].equals("null") ? null : URI.create(splitted[5]);
        String subject = splitted[6].equals("null") ? null : splitted[6];
        OffsetDateTime time = splitted[7].equals("null") ? null : Time.parseTime((String)splitted[7]);
        byte[] data = splitted[8].equals("null") ? null : Base64.getDecoder().decode(splitted[8].getBytes());
        CloudEventBuilder builder = CloudEventBuilder.fromSpecVersion((SpecVersion)sv).withId(id).withType(type).withSource(source);
        if (datacontenttype != null) {
            builder.withDataContentType(datacontenttype);
        }
        if (dataschema != null) {
            builder.withDataSchema(dataschema);
        }
        if (subject != null) {
            builder.withSubject(subject);
        }
        if (time != null) {
            builder.withTime(time);
        }
        if (data != null) {
            builder.withData(mapper.map((CloudEventData)BytesCloudEventData.wrap((byte[])data)));
        }
        return builder.build();
    }

    public Set<String> deserializableContentTypes() {
        return Collections.singleton(this.serializedContentType());
    }

    public String serializedContentType() {
        return "application/cloudevents+csv";
    }
}

