/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v03;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.test.Data;
import io.cloudevents.core.v03.CloudEventBuilder;
import io.cloudevents.core.v03.CloudEventV03;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CloudEventBuilderTest {
    @ParameterizedTest
    @MethodSource(value={"io.cloudevents.core.test.Data#v03Events"})
    void testCopyWithBuilder(CloudEvent event) {
        Assertions.assertThat((Object)io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)event).build()).isEqualTo((Object)event);
    }

    @Test
    void testToV1() {
        CloudEventV03 input = ((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v03().withId("1").withType("mock.test").withSource(Data.SOURCE).withData("application/json", Data.DATASCHEMA, Data.DATA_JSON_SERIALIZED)).withSubject("sub").withTime(Data.TIME).withExtension("astring", "aaa")).withExtension("aboolean", "true")).withExtension("anumber", "10")).build();
        CloudEvent expected = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1().withId("1").withType("mock.test").withSource(Data.SOURCE).withData("application/json", Data.DATASCHEMA, Data.DATA_JSON_SERIALIZED)).withSubject("sub").withTime(Data.TIME).withExtension("astring", "aaa")).withExtension("aboolean", "true")).withExtension("anumber", "10")).build();
        CloudEvent actual = io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)input).build();
        Assertions.assertThat((Comparable)expected.getSpecVersion()).isEqualTo((Object)SpecVersion.V1);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    void testCopyExtensions() {
        CloudEventBuilder templateBuilder = (CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v03().withId("1").withType("mock.test").withSource(Data.SOURCE).withSubject("sub").withTime(Data.TIME).withExtension("astring", "aaa")).withExtension("aboolean", "true")).withExtension("anumber", "10");
        CloudEventV03 event = templateBuilder.build();
        CloudEventV03 cloned = new CloudEventBuilder((CloudEvent)event).build();
        Assertions.assertThat((Object)cloned).isEqualTo((Object)event);
    }

    @Test
    void testNewBuilder() {
        CloudEventBuilder templateBuilder = (CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v03().withId("1").withType("mock.test").withSource(Data.SOURCE).withData("application/json", Data.DATASCHEMA, Data.DATA_JSON_SERIALIZED)).withSubject("sub").withTime(Data.TIME).withExtension("astring", "aaa")).withExtension("aboolean", "true")).withExtension("anumber", "10");
        CloudEventV03 event = templateBuilder.build();
        CloudEventV03 cloned = templateBuilder.newBuilder().build();
        Assertions.assertThat((Object)cloned).isEqualTo((Object)event);
    }

    @Test
    void testDataContentEncoding() {
        CloudEventV03 event = ((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v03().withId("1").withType("mock.test").withSource(Data.SOURCE).withData("application/json", Data.DATASCHEMA, Data.DATA_JSON_SERIALIZED)).withSubject("sub").withTime(Data.TIME).withExtension("astring", "aaa")).withExtension("aboolean", "true")).withExtension("anumber", "10")).build();
        Assertions.assertThat((Object)event.getAttribute("datacontentencoding")).isNull();
    }

    @Test
    void testMissingId() {
        Assertions.assertThatCode(() -> io.cloudevents.core.builder.CloudEventBuilder.v03().withSource(URI.create("http://localhost")).withType("aaa").build()).hasMessageContaining("Attribute 'id' cannot be null");
    }

    @Test
    void testMissingSource() {
        Assertions.assertThatCode(() -> io.cloudevents.core.builder.CloudEventBuilder.v03().withId("000").withType("aaa").build()).hasMessageContaining("Attribute 'source' cannot be null");
    }

    @Test
    void testMissingType() {
        Assertions.assertThatCode(() -> io.cloudevents.core.builder.CloudEventBuilder.v03().withId("000").withSource(URI.create("http://localhost")).build()).hasMessageContaining("Attribute 'type' cannot be null");
    }
}

