package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeAttachmentListBuilder extends VolumeAttachmentListFluentImpl<VolumeAttachmentListBuilder> implements VisitableBuilder<VolumeAttachmentList,VolumeAttachmentListBuilder> {

    VolumeAttachmentListFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeAttachmentListBuilder() {
        this(true);
    }

    public VolumeAttachmentListBuilder(Boolean validationEnabled) {
        this(new VolumeAttachmentList(), validationEnabled);
    }

    public VolumeAttachmentListBuilder(VolumeAttachmentListFluent<?> fluent) {
        this(fluent, true);
    }

    public VolumeAttachmentListBuilder(VolumeAttachmentListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new VolumeAttachmentList(), validationEnabled);
    }

    public VolumeAttachmentListBuilder(VolumeAttachmentListFluent<?> fluent,VolumeAttachmentList instance) {
        this(fluent, instance, true);
    }

    public VolumeAttachmentListBuilder(VolumeAttachmentListFluent<?> fluent,VolumeAttachmentList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public VolumeAttachmentListBuilder(VolumeAttachmentList instance) {
        this(instance,true);
    }

    public VolumeAttachmentListBuilder(VolumeAttachmentList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public VolumeAttachmentList build() {
        VolumeAttachmentList buildable = new VolumeAttachmentList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VolumeAttachmentListBuilder that = (VolumeAttachmentListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
